/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.text.StringCharacterIterator;
import java.util.Locale;

public final class ByteValue {
    private static final int CONVERSION_FACTOR_KB = 1024;
    private static final int CONVERSION_FACTOR_MB = 0x100000;
    private static final int CONVERSION_FACTOR_GB = 0x40000000;

    public static long ofKilobytes(long value) {
        return value * 1024L;
    }

    public static long ofMegabytes(long value) {
        return value * 0x100000L;
    }

    public static long ofGigabytes(long value) {
        return value * 0x40000000L;
    }

    public static String prettyPrint(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Value must be >= 0");
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        long value = bytes;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && bytes > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format(Locale.US, "%.1f %cB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }
}

