/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.support;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

class ObjectToObjectConverterRuntimeHints
implements RuntimeHintsRegistrar {
    ObjectToObjectConverterRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        TypeReference sqlDateTypeReference = TypeReference.of("java.sql.Date");
        hints.reflection().registerTypeIfPresent(classLoader, sqlDateTypeReference.getName(), hint -> hint.withMethod("toLocalDate", Collections.emptyList(), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference).withMethod("valueOf", List.of(TypeReference.of(LocalDate.class)), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference));
        hints.reflection().registerTypeIfPresent(classLoader, "org.springframework.http.HttpMethod", builder -> builder.withMethod("valueOf", List.of(TypeReference.of(String.class)), ExecutableMode.INVOKE));
    }
}

