/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluatedDecision;
import io.camunda.zeebe.client.api.response.EvaluatedDecisionInput;
import io.camunda.zeebe.client.api.response.MatchedDecisionRule;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionInputImpl;
import io.camunda.zeebe.client.impl.response.MatchedDecisionRuleImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;

public class EvaluatedDecisionImpl
implements EvaluatedDecision {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final String decisionId;
    private final long decisionKey;
    private final int decisionVersion;
    private final String decisionName;
    private final String decisionType;
    private final String decisionOutput;
    private final List<MatchedDecisionRule> matchedRules = new ArrayList<MatchedDecisionRule>();
    private final List<EvaluatedDecisionInput> evaluatedInputs = new ArrayList<EvaluatedDecisionInput>();

    public EvaluatedDecisionImpl(JsonMapper jsonMapper, GatewayOuterClass.EvaluatedDecision evaluatedDecision) {
        this.jsonMapper = jsonMapper;
        this.decisionId = evaluatedDecision.getDecisionId();
        this.decisionKey = evaluatedDecision.getDecisionKey();
        this.decisionName = evaluatedDecision.getDecisionName();
        this.decisionVersion = evaluatedDecision.getDecisionVersion();
        this.decisionType = evaluatedDecision.getDecisionType();
        this.decisionOutput = evaluatedDecision.getDecisionOutput();
        evaluatedDecision.getEvaluatedInputsList().stream().map(evaluatedInput -> new EvaluatedDecisionInputImpl(jsonMapper, (GatewayOuterClass.EvaluatedDecisionInput)evaluatedInput)).forEach(this.evaluatedInputs::add);
        evaluatedDecision.getMatchedRulesList().stream().map(matchedRule -> new MatchedDecisionRuleImpl(jsonMapper, (GatewayOuterClass.MatchedDecisionRule)matchedRule)).forEach(this.matchedRules::add);
    }

    @Override
    public String getDecisionId() {
        return this.decisionId;
    }

    @Override
    public int getDecisionVersion() {
        return this.decisionVersion;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionName() {
        return this.decisionName;
    }

    @Override
    public String getDecisionType() {
        return this.decisionType;
    }

    @Override
    public String getDecisionOutput() {
        return this.decisionOutput;
    }

    @Override
    public List<EvaluatedDecisionInput> getEvaluatedInputs() {
        return this.evaluatedInputs;
    }

    @Override
    public List<MatchedDecisionRule> getMatchedRules() {
        return this.matchedRules;
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    public String toString() {
        return this.toJson();
    }
}

