/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentWriter;
import io.camunda.zeebe.journal.file.SegmentsFlusher;
import io.camunda.zeebe.journal.file.SegmentsManager;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;

final class SegmentedJournalWriter {
    private final SegmentsManager segments;
    private final SegmentsFlusher flusher;
    private final JournalMetrics journalMetrics;
    private Segment currentSegment;
    private SegmentWriter currentWriter;

    SegmentedJournalWriter(SegmentsManager segments, SegmentsFlusher flusher, JournalMetrics journalMetrics) {
        this.segments = segments;
        this.flusher = flusher;
        this.journalMetrics = journalMetrics;
        this.currentSegment = segments.getLastSegment();
        this.currentWriter = this.currentSegment.writer();
    }

    long getLastIndex() {
        return this.currentWriter.getLastIndex();
    }

    long getNextIndex() {
        return this.currentWriter.getNextIndex();
    }

    JournalRecord append(long asqn, BufferWriter recordDataWriter) {
        Either<JournalException.SegmentFull, JournalRecord> appendResult = this.currentWriter.append(asqn, recordDataWriter);
        if (appendResult.isRight()) {
            return (JournalRecord)appendResult.get();
        }
        if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
            throw new JournalException.SegmentSizeTooSmall("Failed appending, segment size is too small");
        }
        this.journalMetrics.observeSegmentCreation(this::createNewSegment);
        Either<JournalException.SegmentFull, JournalRecord> appendResultOnNewSegment = this.currentWriter.append(asqn, recordDataWriter);
        if (appendResultOnNewSegment.isLeft()) {
            throw (JournalException.SegmentFull)appendResultOnNewSegment.getLeft();
        }
        return (JournalRecord)appendResultOnNewSegment.get();
    }

    void append(JournalRecord record) {
        Either<JournalException.SegmentFull, JournalRecord> appendResult = this.currentWriter.append(record);
        if (appendResult.isRight()) {
            return;
        }
        if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
            throw new JournalException.SegmentSizeTooSmall("Failed appending, segment size is too small");
        }
        this.journalMetrics.observeSegmentCreation(this::createNewSegment);
        Either<JournalException.SegmentFull, JournalRecord> resultInNewSegment = this.currentWriter.append(record);
        if (resultInNewSegment.isLeft()) {
            throw (JournalException.SegmentFull)resultInNewSegment.getLeft();
        }
    }

    void reset(long index) {
        this.flusher.setLastFlushedIndex(index - 1L);
        this.currentSegment = this.segments.resetSegments(index);
        this.currentWriter = this.currentSegment.writer();
    }

    void deleteAfter(long index) {
        while (index < this.currentSegment.index() && this.currentSegment != this.segments.getFirstSegment()) {
            this.segments.removeSegment(this.currentSegment);
            this.currentSegment = this.segments.getLastSegment();
            this.currentWriter = this.currentSegment.writer();
        }
        this.flusher.setLastFlushedIndex(index);
        this.currentWriter.truncate(index);
    }

    void flush() {
        this.flusher.flush(this.segments.getTailSegments(this.flusher.nextFlushIndex()));
    }

    private void createNewSegment() {
        this.currentSegment = this.segments.getNextSegment();
        this.currentWriter = this.currentSegment.writer();
    }
}

