/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.api.NoSuchStreamException;
import io.camunda.zeebe.transport.stream.api.StreamExhaustedException;
import io.camunda.zeebe.transport.stream.impl.ClientStream;
import io.camunda.zeebe.transport.stream.impl.ClientStreamIdImpl;
import io.camunda.zeebe.transport.stream.impl.ClientStreamRequestManager;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AggregatedClientStream<M extends BufferWriter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatedClientStream.class);
    private final UUID streamId;
    private final LogicalId<M> logicalId;
    private final Set<MemberId> liveConnections = new HashSet<MemberId>();
    private final ClientStreamMetrics metrics;
    private final Int2ObjectHashMap<ClientStream<M>> clientStreams = new Int2ObjectHashMap();
    private State state;
    private int nextLocalId;

    AggregatedClientStream(UUID streamId, LogicalId<M> logicalId) {
        this(streamId, logicalId, ClientStreamMetrics.noop());
    }

    AggregatedClientStream(UUID streamId, LogicalId<M> logicalId, ClientStreamMetrics metrics) {
        this.streamId = streamId;
        this.logicalId = logicalId;
        this.metrics = metrics;
        this.state = State.INITIAL;
    }

    void addClient(ClientStream<M> clientStream) {
        this.clientStreams.put(clientStream.streamId().localId(), clientStream);
        this.metrics.observeAggregatedClientCount(this.clientStreams.size());
    }

    UUID getStreamId() {
        return this.streamId;
    }

    DirectBuffer getStreamType() {
        return this.logicalId.streamType();
    }

    M getMetadata() {
        return (M)((BufferWriter)this.logicalId.metadata());
    }

    int nextLocalId() {
        int localId = this.nextLocalId++;
        return localId;
    }

    void add(MemberId serverId) {
        this.liveConnections.add(serverId);
    }

    boolean isConnected(MemberId serverId) {
        return this.liveConnections.contains(serverId);
    }

    void remove(MemberId serverId) {
        this.liveConnections.remove(serverId);
    }

    void close() {
        this.state = State.CLOSED;
    }

    boolean isClosed() {
        return this.state == State.CLOSED;
    }

    void removeClient(ClientStreamIdImpl streamId) {
        this.clientStreams.remove(streamId.localId());
        this.metrics.observeAggregatedClientCount(this.clientStreams.size());
    }

    boolean isEmpty() {
        return this.clientStreams.isEmpty();
    }

    LogicalId<M> logicalId() {
        return this.logicalId;
    }

    void push(DirectBuffer buffer, ActorFuture<Void> future) {
        Int2ObjectHashMap.ValueCollection streams = this.clientStreams.values();
        if (streams.isEmpty()) {
            throw new NoSuchStreamException();
        }
        ArrayList<ClientStream<M>> targets = new ArrayList<ClientStream<M>>(streams);
        int index = ThreadLocalRandom.current().nextInt(streams.size());
        this.tryPush(targets, index, 1, buffer, future);
    }

    private void tryPush(ArrayList<ClientStream<M>> targets, int index, int currentCount, DirectBuffer buffer, ActorFuture<Void> future) {
        ClientStream<M> clientStream = targets.get(index);
        LOGGER.trace("Pushing data from stream [{}] to client [{}]", (Object)this.streamId, (Object)clientStream.streamId());
        clientStream.clientStreamConsumer().push(buffer).onComplete((ok, pushFailed) -> {
            if (pushFailed == null) {
                future.complete(null);
            } else if (currentCount >= targets.size()) {
                StreamExhaustedException error = new StreamExhaustedException("Failed to push data to all available clients. No more clients left to retry.");
                error.addSuppressed((Throwable)pushFailed);
                future.completeExceptionally((Throwable)error);
            } else {
                LOGGER.warn("Failed to push data to client [{}], retrying with next client.", (Object)clientStream.streamId(), pushFailed);
                this.tryPush(targets, (index + 1) % targets.size(), currentCount + 1, buffer, future);
            }
        });
    }

    void open(ClientStreamRequestManager<M> requestManager, Set<MemberId> servers) {
        if (this.state == State.INITIAL) {
            requestManager.openStream(this, servers);
            this.state = State.OPEN;
        }
    }

    record LogicalId<M>(DirectBuffer streamType, M metadata) {
    }

    private static enum State {
        INITIAL,
        OPEN,
        CLOSED;

    }
}

