/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.transport.stream.impl.AggregatedClientStream;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.StreamTopics;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.time.Duration;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientStreamRequestManager<M extends BufferWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStreamRequestManager.class);
    private static final byte[] REMOVE_ALL_REQUEST = new byte[0];
    private static final Duration RETRY_DELAY = Duration.ofSeconds(1L);
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private final ClusterCommunicationService communicationService;
    private final ConcurrencyControl executor;

    ClientStreamRequestManager(ClusterCommunicationService communicationService, ConcurrencyControl executor) {
        this.communicationService = communicationService;
        this.executor = executor;
    }

    void openStream(AggregatedClientStream<M> clientStream, Collection<MemberId> servers) {
        AddStreamRequest request = new AddStreamRequest().streamType(clientStream.getStreamType()).streamId(clientStream.getStreamId()).metadata((BufferWriter)clientStream.getMetadata());
        servers.forEach(brokerId -> this.executor.run(() -> this.doAdd(request, (MemberId)brokerId, clientStream)));
    }

    private void doAdd(AddStreamRequest request, MemberId brokerId, AggregatedClientStream<M> clientStream) {
        if (clientStream.isConnected(brokerId) || clientStream.isClosed()) {
            return;
        }
        CompletableFuture result = this.communicationService.send(StreamTopics.ADD.topic(), (Object)request, BufferUtil::bufferAsArray, Function.identity(), brokerId, REQUEST_TIMEOUT);
        result.whenCompleteAsync((ignored, error) -> {
            if (error != null) {
                LOG.warn("Failed to open stream {} to node {}. Will retry in {}", new Object[]{clientStream, brokerId, RETRY_DELAY});
                this.executor.schedule(RETRY_DELAY, () -> this.doAdd(request, brokerId, clientStream));
            } else {
                LOG.debug("Opened stream {} to node {}", (Object)clientStream, (Object)brokerId);
                clientStream.add(brokerId);
            }
        }, arg_0 -> ((ConcurrencyControl)this.executor).run(arg_0));
    }

    void removeStream(AggregatedClientStream<M> clientStream, Collection<MemberId> servers) {
        RemoveStreamRequest request = new RemoveStreamRequest().streamId(clientStream.getStreamId());
        servers.forEach(brokerId -> this.executor.run(() -> this.doRemove(request, (MemberId)brokerId, clientStream)));
    }

    private void doRemove(RemoveStreamRequest request, MemberId brokerId, AggregatedClientStream<M> clientStream) {
        CompletableFuture result = this.communicationService.send(StreamTopics.REMOVE.topic(), (Object)request, BufferUtil::bufferAsArray, Function.identity(), brokerId, REQUEST_TIMEOUT);
        result.whenCompleteAsync((ignored, error) -> {
            if (error != null && clientStream.isConnected(brokerId)) {
                this.executor.schedule(RETRY_DELAY, () -> this.doRemove(request, brokerId, clientStream));
            } else {
                LOG.debug("Removed stream {} to node {}", (Object)clientStream, (Object)brokerId);
                clientStream.remove(brokerId);
            }
        }, arg_0 -> ((ConcurrencyControl)this.executor).run(arg_0));
    }

    void removeAll(Collection<MemberId> servers) {
        servers.forEach(this::doRemoveAll);
    }

    private void doRemoveAll(MemberId brokerId) {
        this.communicationService.unicast(StreamTopics.REMOVE_ALL.topic(), (Object)REMOVE_ALL_REQUEST, Function.identity(), brokerId, true);
    }

    void removeStreamUnreliable(UUID streamId, Collection<MemberId> servers) {
        RemoveStreamRequest request = new RemoveStreamRequest().streamId(streamId);
        servers.forEach(serverId -> this.communicationService.unicast(StreamTopics.REMOVE.topic(), (Object)request, BufferUtil::bufferAsArray, serverId, true));
    }
}

