/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.ClientStreamConsumer;
import io.camunda.zeebe.transport.stream.api.ClientStreamId;
import io.camunda.zeebe.transport.stream.api.ClientStreamer;
import io.camunda.zeebe.transport.stream.impl.ClientStreamManager;
import io.camunda.zeebe.transport.stream.impl.ClientStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.ClientStreamRequestManager;
import io.camunda.zeebe.transport.stream.impl.messages.MessageUtil;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.StreamTopics;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class ClientStreamService<M extends BufferWriter>
extends Actor
implements ClientStreamer<M> {
    private final ClientStreamManager<M> clientStreamManager;
    private final ClusterCommunicationService communicationService;

    public ClientStreamService(ClusterCommunicationService communicationService) {
        this.clientStreamManager = new ClientStreamManager(new ClientStreamRegistry(), new ClientStreamRequestManager(communicationService, (ConcurrencyControl)this.actor));
        this.communicationService = communicationService;
    }

    protected void onActorStarted() {
        this.communicationService.subscribe(StreamTopics.PUSH.topic(), MessageUtil::parsePushRequest, request -> {
            CompletableFuture responseFuture = new CompletableFuture();
            this.actor.run(() -> {
                try {
                    CompletableActorFuture payloadPushed = new CompletableActorFuture();
                    this.clientStreamManager.onPayloadReceived((PushStreamRequest)request, (ActorFuture<Void>)payloadPushed);
                    payloadPushed.onComplete((ok, error) -> {
                        if (error == null) {
                            responseFuture.complete(null);
                        } else {
                            responseFuture.completeExceptionally((Throwable)error);
                        }
                    });
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            });
            return responseFuture;
        }, ignore -> new byte[0]);
    }

    protected void onActorCloseRequested() {
        this.clientStreamManager.removeAll();
    }

    @Override
    public ActorFuture<ClientStreamId> add(DirectBuffer streamType, M metadata, ClientStreamConsumer clientStreamConsumer) {
        return this.actor.call(() -> this.clientStreamManager.add(streamType, (BufferWriter)metadata, clientStreamConsumer));
    }

    @Override
    public ActorFuture<Void> remove(ClientStreamId streamId) {
        return this.actor.call(() -> this.clientStreamManager.remove(streamId));
    }

    public void onServerJoined(MemberId memberId) {
        this.actor.run(() -> this.clientStreamManager.onServerJoined(memberId));
    }

    public void onServerRemoved(MemberId memberId) {
        this.actor.run(() -> this.clientStreamManager.onServerRemoved(memberId));
    }
}

