/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.api.RemoteStream;
import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.ImmutableStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequest;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteStreamPusher<P extends BufferWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStreamPusher.class);
    private final RemoteStreamMetrics metrics;
    private final ImmutableStreamRegistry.StreamId streamId;
    private final Transport transport;
    private final Executor executor;

    RemoteStreamPusher(ImmutableStreamRegistry.StreamId streamId, Transport transport, Executor executor, RemoteStreamMetrics metrics) {
        this.metrics = metrics;
        this.streamId = Objects.requireNonNull(streamId, "must specify a target stream ID");
        this.transport = Objects.requireNonNull(transport, "must provide a network transport");
        this.executor = Objects.requireNonNull(executor, "must provide an asynchronous executor");
    }

    public void pushAsync(P payload, RemoteStream.ErrorHandler<P> errorHandler) {
        Objects.requireNonNull(payload, "must specify a payload");
        Objects.requireNonNull(errorHandler, "must specify a error handler");
        this.executor.execute(() -> this.push(payload, this.instrumentingErrorHandler(errorHandler)));
    }

    private RemoteStream.ErrorHandler<P> instrumentingErrorHandler(RemoteStream.ErrorHandler<P> errorHandler) {
        return (error, payload) -> {
            if (error != null) {
                this.metrics.pushFailed();
                LOG.debug("Failed to push {} to stream {}", new Object[]{payload, this.streamId, error});
                errorHandler.handleError(error, payload);
            }
        };
    }

    private void push(P payload, RemoteStream.ErrorHandler<P> errorHandler) {
        PushStreamRequest request = new PushStreamRequest().streamId(this.streamId.streamId()).payload((BufferWriter)payload);
        try {
            this.transport.send(request, this.streamId.receiver()).whenCompleteAsync((ok, error) -> this.onPush(payload, errorHandler, (Throwable)error), this.executor);
            LOG.trace("Pushed {} to stream {}", payload, (Object)this.streamId);
        }
        catch (Exception e) {
            errorHandler.handleError(e, payload);
        }
    }

    private void onPush(P payload, RemoteStream.ErrorHandler<P> errorHandler, Throwable error) {
        if (error != null) {
            errorHandler.handleError(error, payload);
        } else {
            this.metrics.pushSucceeded();
        }
    }

    static interface Transport {
        public CompletableFuture<Void> send(PushStreamRequest var1, MemberId var2) throws Exception;
    }
}

