/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.ImmutableStreamRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.agrona.concurrent.UnsafeBuffer;

public class RemoteStreamRegistry<M>
implements ImmutableStreamRegistry<M> {
    private final RemoteStreamMetrics metrics;
    private final ConcurrentMap<UnsafeBuffer, Set<ImmutableStreamRegistry.StreamConsumer<M>>> typeToConsumers = new ConcurrentHashMap<UnsafeBuffer, Set<ImmutableStreamRegistry.StreamConsumer<M>>>();
    private final Map<ImmutableStreamRegistry.StreamId, ImmutableStreamRegistry.StreamConsumer<M>> idToConsumer = new HashMap<ImmutableStreamRegistry.StreamId, ImmutableStreamRegistry.StreamConsumer<M>>();

    public RemoteStreamRegistry(RemoteStreamMetrics metrics) {
        this.metrics = metrics;
    }

    public void add(UnsafeBuffer streamType, UUID streamId, MemberId receiver, M properties) {
        ImmutableStreamRegistry.StreamId uniqueId = new ImmutableStreamRegistry.StreamId(streamId, receiver);
        if (this.idToConsumer.containsKey(uniqueId)) {
            return;
        }
        this.typeToConsumers.putIfAbsent(streamType, new CopyOnWriteArraySet());
        ImmutableStreamRegistry.StreamConsumer<M> streamConsumer = new ImmutableStreamRegistry.StreamConsumer<M>(uniqueId, properties, streamType);
        this.idToConsumer.put(uniqueId, streamConsumer);
        ((Set)this.typeToConsumers.get(streamType)).add(streamConsumer);
        this.metrics.addStream();
    }

    public void remove(UUID streamId, MemberId receiver) {
        ImmutableStreamRegistry.StreamId uniqueId = new ImmutableStreamRegistry.StreamId(streamId, receiver);
        ImmutableStreamRegistry.StreamConsumer consumer = this.idToConsumer.remove(uniqueId);
        if (consumer != null) {
            this.typeToConsumers.computeIfPresent(consumer.streamType(), (type, consumerSet) -> {
                consumerSet.remove(consumer);
                return consumerSet.isEmpty() ? null : consumerSet;
            });
            this.metrics.removeStream();
        }
    }

    public void removeAll(MemberId receiver) {
        List<ImmutableStreamRegistry.StreamId> streamOfReceiver = this.idToConsumer.keySet().stream().filter(id -> id.receiver().equals((Object)receiver)).toList();
        streamOfReceiver.forEach(stream -> this.remove(stream.streamId(), stream.receiver()));
    }

    @Override
    public Set<ImmutableStreamRegistry.StreamConsumer<M>> get(UnsafeBuffer streamType) {
        return this.typeToConsumers.getOrDefault(streamType, Collections.emptySet());
    }

    public void clear() {
        this.typeToConsumers.clear();
        this.idToConsumer.clear();
    }
}

