/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.Member;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import io.camunda.zeebe.transport.stream.api.RemoteStreamer;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamEndpoint;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamerImpl;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.stream.Stream;

public class RemoteStreamServiceImpl<M extends BufferReader, P extends BufferWriter>
implements RemoteStreamService<M, P> {
    private final RemoteStreamerImpl<M, P> streamer;
    private final RemoteStreamEndpoint<M> apiServer;

    public RemoteStreamServiceImpl(RemoteStreamerImpl<M, P> streamer, RemoteStreamEndpoint<M> apiServer) {
        this.streamer = streamer;
        this.apiServer = apiServer;
    }

    @Override
    public ActorFuture<RemoteStreamer<M, P>> start(ActorSchedulingService actorSchedulingService, ConcurrencyControl executor) {
        CompletableActorFuture future = new CompletableActorFuture();
        ActorFuture streamerStarted = actorSchedulingService.submitActor(this.streamer);
        ActorFuture serverStarted = actorSchedulingService.submitActor(this.apiServer);
        ActorFuture combined = (ActorFuture)Stream.of(streamerStarted, serverStarted).collect(new ActorFutureCollector(executor));
        executor.runOnCompletion(combined, (ok, error) -> {
            if (error != null) {
                future.completeExceptionally(error);
            } else {
                future.complete(this.streamer);
            }
        });
        return future;
    }

    @Override
    public ActorFuture<Void> closeAsync(ConcurrencyControl executor) {
        CompletableActorFuture closed = new CompletableActorFuture();
        ActorFuture streamerClosed = this.streamer.closeAsync();
        ActorFuture serverClosed = this.apiServer.closeAsync();
        ActorFuture combined = (ActorFuture)Stream.of(streamerClosed, serverClosed).collect(new ActorFutureCollector(executor));
        executor.runOnCompletion(combined, (ok, error) -> {
            if (error != null) {
                closed.completeExceptionally(error);
            } else {
                closed.complete(null);
            }
        });
        return closed;
    }

    public boolean isRelevant(ClusterMembershipEvent event) {
        return event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED;
    }

    public void event(ClusterMembershipEvent event) {
        this.apiServer.removeAll(((Member)event.subject()).id());
    }
}

