package io.camunda.zeebe.shared.management.openapi.models;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Request body for take backup
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "TakeBackupRequest", description = "Request body for take backup")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-09-07T18:46:53.397675297Z[GMT]")
public class TakeBackupRequest {

  private Long backupId;

  public TakeBackupRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public TakeBackupRequest(Long backupId) {
    this.backupId = backupId;
  }

  public TakeBackupRequest backupId(Long backupId) {
    this.backupId = backupId;
    return this;
  }

  /**
   * The ID of the backup. The ID of the backup must be a positive numerical value. As backups are logically ordered by their IDs (ascending), each successive backup must use a higher ID than the previous one. 
   * minimum: 0
   * @return backupId
  */
  @NotNull @Min(0L) 
  @Schema(name = "backupId", example = "1", description = "The ID of the backup. The ID of the backup must be a positive numerical value. As backups are logically ordered by their IDs (ascending), each successive backup must use a higher ID than the previous one. ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("backupId")
  public Long getBackupId() {
    return backupId;
  }

  public void setBackupId(Long backupId) {
    this.backupId = backupId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TakeBackupRequest takeBackupRequest = (TakeBackupRequest) o;
    return Objects.equals(this.backupId, takeBackupRequest.backupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(backupId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TakeBackupRequest {\n");
    sb.append("    backupId: ").append(toIndentedString(backupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

