/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public final class ActorSchedulerConfiguration {
    private final BrokerCfg brokerCfg;
    private final ActorClockConfiguration actorClockConfiguration;

    @Autowired
    public ActorSchedulerConfiguration(BrokerCfg brokerCfg, ActorClockConfiguration actorClockConfiguration) {
        this.brokerCfg = brokerCfg;
        this.actorClockConfiguration = actorClockConfiguration;
    }

    @Bean(destroyMethod="close")
    public ActorScheduler scheduler() {
        ThreadsCfg cfg = this.brokerCfg.getThreads();
        int cpuThreads = cfg.getCpuThreadCount();
        int ioThreads = cfg.getIoThreadCount();
        boolean metricsEnabled = this.brokerCfg.getExperimental().getFeatures().isEnableActorMetrics();
        return ActorScheduler.newActorScheduler().setActorClock((ActorClock)this.actorClockConfiguration.getClock().orElse(null)).setCpuBoundActorThreadCount(cpuThreads).setIoBoundActorThreadCount(ioThreads).setMetricsEnabled(metricsEnabled).setSchedulerName(String.format("Broker-%d", this.brokerCfg.getCluster().getNodeId())).build();
    }
}

