/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.SpringGatewayBridge;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyListener;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.shared.MainSupport;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.VersionUtil;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(proxyBeanMethods=false, scanBasePackages={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared", "io.camunda.zeebe.util.liveness"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared"})
public class StandaloneGateway
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
CloseableSilently {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final GatewayCfg configuration;
    private final SpringGatewayBridge springGatewayBridge;
    private final ActorScheduler actorScheduler;
    private final AtomixCluster atomixCluster;
    private final BrokerClient brokerClient;
    private final JobStreamClient jobStreamClient;
    private Gateway gateway;

    @Autowired
    public StandaloneGateway(GatewayCfg configuration, SpringGatewayBridge springGatewayBridge, ActorScheduler actorScheduler, AtomixCluster atomixCluster, BrokerClient brokerClient, JobStreamClient jobStreamClient) {
        this.configuration = configuration;
        this.springGatewayBridge = springGatewayBridge;
        this.actorScheduler = actorScheduler;
        this.atomixCluster = atomixCluster;
        this.brokerClient = brokerClient;
        this.jobStreamClient = jobStreamClient;
    }

    public static void main(String[] args) {
        MainSupport.setDefaultGlobalConfiguration();
        MainSupport.putSystemPropertyIfAbsent("spring.banner.location", "classpath:/assets/zeebe_gateway_banner.txt");
        SpringApplication application = MainSupport.createDefaultApplicationBuilder().sources(new Class[]{StandaloneGateway.class}).profiles(new String[]{Profile.GATEWAY.getId()}).build(args);
        application.run(new String[0]);
    }

    public void run(String ... args) throws Exception {
        this.configuration.init();
        if (LOG.isInfoEnabled()) {
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting standalone gateway with configuration {}", (Object)this.configuration.toJson());
        }
        this.actorScheduler.start();
        this.atomixCluster.start();
        this.jobStreamClient.start().join();
        this.brokerClient.start().forEach(ActorFuture::join);
        this.brokerClient.getTopologyManager().addTopologyListener((BrokerTopologyListener)this.jobStreamClient);
        this.gateway = new Gateway(this.configuration, this.brokerClient, (ActorSchedulingService)this.actorScheduler, this.jobStreamClient.streamer());
        this.springGatewayBridge.registerGatewayStatusSupplier(() -> ((Gateway)this.gateway).getStatus());
        this.springGatewayBridge.registerClusterStateSupplier(() -> Optional.ofNullable(this.gateway.getBrokerClient()).map(BrokerClient::getTopologyManager).map(BrokerTopologyManager::getTopology));
        this.springGatewayBridge.registerJobStreamClient(() -> this.jobStreamClient);
        this.gateway.start().join(30L, TimeUnit.SECONDS);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.close();
    }

    public void close() {
        if (this.gateway != null) {
            try {
                this.gateway.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to gracefully shutdown gRPC gateway", (Throwable)e);
            }
        }
    }
}

