/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.restore;

import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.backup.gcs.GcsBackupConfig;
import io.camunda.zeebe.backup.gcs.GcsBackupStore;
import io.camunda.zeebe.backup.s3.S3BackupConfig;
import io.camunda.zeebe.backup.s3.S3BackupStore;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.backup.GcsBackupStoreConfig;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
final class BackupStoreComponent {
    private final BrokerCfg brokerCfg;

    @Autowired
    BackupStoreComponent(BrokerCfg brokerCfg) {
        this.brokerCfg = brokerCfg;
    }

    @Bean(destroyMethod="closeAsync")
    BackupStore backupStore() {
        return this.buildBackupStore(this.brokerCfg.getData().getBackup());
    }

    private BackupStore buildBackupStore(BackupStoreCfg backupCfg) {
        BackupStoreCfg.BackupStoreType store = backupCfg.getStore();
        return switch (store) {
            default -> throw new IncompatibleClassChangeError();
            case BackupStoreCfg.BackupStoreType.S3 -> BackupStoreComponent.buildS3BackupStore(backupCfg);
            case BackupStoreCfg.BackupStoreType.GCS -> BackupStoreComponent.buildGcsBackupStore(backupCfg);
            case BackupStoreCfg.BackupStoreType.NONE -> throw new IllegalArgumentException("No backup store configured, cannot restore from backup.");
        };
    }

    private static S3BackupStore buildS3BackupStore(BackupStoreCfg backupStoreCfg) {
        S3BackupConfig storeConfig = S3BackupStoreConfig.toStoreConfig((S3BackupStoreConfig)backupStoreCfg.getS3());
        return new S3BackupStore(storeConfig);
    }

    private static GcsBackupStore buildGcsBackupStore(BackupStoreCfg backupStoreCfg) {
        GcsBackupConfig storeConfig = GcsBackupStoreConfig.toStoreConfig((GcsBackupStoreConfig)backupStoreCfg.getGcs());
        return new GcsBackupStore(storeConfig);
    }
}

