/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.ClusterTopologyManagerImpl;
import io.camunda.zeebe.topology.PersistedClusterTopology;
import io.camunda.zeebe.topology.StaticConfiguration;
import io.camunda.zeebe.topology.TopologyInitializer;
import io.camunda.zeebe.topology.changes.NoopTopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliersImpl;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinatorImpl;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiper;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiperConfig;
import io.camunda.zeebe.topology.serializer.ProtoBufSerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

public final class ClusterTopologyManagerService
extends Actor {
    private static final String COORDINATOR_ID = "0";
    private static final String TOPOLOGY_FILE_NAME = ".topology.meta";
    private final ClusterTopologyManagerImpl clusterTopologyManager;
    private final ClusterTopologyGossiper clusterTopologyGossiper;
    private final boolean isCoordinator;
    private final PersistedClusterTopology persistedClusterTopology;
    private final Path topologyFile;

    public ClusterTopologyManagerService(Path dataRootDirectory, ClusterCommunicationService communicationService, ClusterMembershipService memberShipService, ClusterTopologyGossiperConfig config) {
        try {
            FileUtil.ensureDirectoryExists((Path)dataRootDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create data directory", e);
        }
        MemberId localMemberId = memberShipService.getLocalMember().id();
        this.topologyFile = dataRootDirectory.resolve(TOPOLOGY_FILE_NAME);
        this.persistedClusterTopology = new PersistedClusterTopology(this.topologyFile, new ProtoBufSerializer());
        this.clusterTopologyManager = new ClusterTopologyManagerImpl((ConcurrencyControl)this, localMemberId, this.persistedClusterTopology);
        this.clusterTopologyGossiper = new ClusterTopologyGossiper((ConcurrencyControl)this, communicationService, memberShipService, new ProtoBufSerializer(), config, this.clusterTopologyManager::onGossipReceived);
        this.clusterTopologyManager.setTopologyGossiper(this.clusterTopologyGossiper::updateClusterTopology);
        this.isCoordinator = ((String)((Object)localMemberId.id())).equals(COORDINATOR_ID);
    }

    private TopologyInitializer getNonCoordinatorInitializer() {
        return new TopologyInitializer.FileInitializer(this.topologyFile, new ProtoBufSerializer()).orThen(new TopologyInitializer.GossipInitializer(this.clusterTopologyGossiper, this.persistedClusterTopology, this.clusterTopologyGossiper::updateClusterTopology, (ConcurrencyControl)this));
    }

    private TopologyInitializer getCoordinatorInitializer(StaticConfiguration staticConfiguration) {
        List<MemberId> knownMembers = staticConfiguration.clusterMembers().stream().filter(m -> !m.equals((Object)staticConfiguration.localMemberId())).toList();
        return new TopologyInitializer.FileInitializer(this.topologyFile, new ProtoBufSerializer()).orThen(new TopologyInitializer.SyncInitializer(this.clusterTopologyGossiper, knownMembers, (ConcurrencyControl)this, this.clusterTopologyGossiper::queryClusterTopology)).orThen(new TopologyInitializer.StaticInitializer(staticConfiguration));
    }

    public ActorFuture<Void> start(ActorSchedulingService actorSchedulingService, StaticConfiguration staticConfiguration) {
        CompletableActorFuture startFuture = new CompletableActorFuture();
        actorSchedulingService.submitActor((Actor)this).onComplete((ignore, error) -> {
            if (error == null) {
                this.actor.run(() -> this.startClusterTopologyServices(staticConfiguration, (CompletableActorFuture<Void>)startFuture));
            } else {
                startFuture.completeExceptionally(error);
            }
        });
        return startFuture;
    }

    private void startClusterTopologyServices(StaticConfiguration staticConfiguration, CompletableActorFuture<Void> startFuture) {
        TopologyInitializer topologyInitializer = this.isCoordinator ? this.getCoordinatorInitializer(staticConfiguration) : this.getNonCoordinatorInitializer();
        this.clusterTopologyGossiper.start().onComplete((ignore, error) -> {
            if (error != null) {
                startFuture.completeExceptionally(error);
            } else {
                this.clusterTopologyManager.start(topologyInitializer).onComplete((BiConsumer)startFuture);
            }
        });
    }

    public ActorFuture<ClusterTopology> getClusterTopology() {
        return this.clusterTopologyManager.getClusterTopology();
    }

    public Optional<TopologyChangeCoordinator> getTopologyChangeCoordinator() {
        return this.isCoordinator ? Optional.of(new TopologyChangeCoordinatorImpl(this.clusterTopologyManager, (ConcurrencyControl)this)) : Optional.empty();
    }

    protected void onActorClosing() {
        this.clusterTopologyGossiper.closeAsync();
    }

    public void registerPartitionChangeExecutor(PartitionChangeExecutor partitionChangeExecutor) {
        this.clusterTopologyManager.registerTopologyChangeAppliers(new TopologyChangeAppliersImpl(partitionChangeExecutor, new NoopTopologyMembershipChangeExecutor()));
    }

    public void removePartitionChangeExecutor() {
        this.clusterTopologyManager.removeTopologyChangeAppliers();
    }
}

