/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiper;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiperConfig;
import io.camunda.zeebe.topology.serializer.ProtoBufSerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import java.util.HashSet;
import java.util.Set;

public class GatewayClusterTopologyService
extends Actor {
    private final Set<Listener> topologyChangeListeners = new HashSet<Listener>();
    private final ClusterTopologyGossiper clusterTopologyGossiper;
    private ClusterTopology clusterTopology = ClusterTopology.uninitialized();

    public GatewayClusterTopologyService(ClusterCommunicationService communicationService, ClusterMembershipService memberShipService, ClusterTopologyGossiperConfig config) {
        this.clusterTopologyGossiper = new ClusterTopologyGossiper((ConcurrencyControl)this, communicationService, memberShipService, new ProtoBufSerializer(), config, this::updateClusterTopology);
    }

    private ActorFuture<ClusterTopology> updateClusterTopology(ClusterTopology clusterTopology) {
        CompletableActorFuture updated = new CompletableActorFuture();
        this.actor.run(() -> {
            try {
                ClusterTopology updateTopology = this.clusterTopology.merge(clusterTopology);
                if (!updateTopology.equals(this.clusterTopology)) {
                    this.clusterTopology = updateTopology;
                    this.topologyChangeListeners.forEach(listener -> listener.onClusterTopologyChanged(updateTopology));
                }
                updated.complete((Object)updateTopology);
            }
            catch (Exception updateFailed) {
                updated.completeExceptionally((Throwable)updateFailed);
            }
        });
        return updated;
    }

    protected void onActorStarting() {
        this.clusterTopologyGossiper.start();
    }

    protected void onActorClosing() {
        this.clusterTopologyGossiper.closeAsync();
    }

    public void registerClusterTopologyChangeListener(Listener listener) {
        this.actor.run(() -> {
            this.topologyChangeListeners.add(listener);
            if (!this.clusterTopology.isUninitialized()) {
                listener.onClusterTopologyChanged(this.clusterTopology);
            }
        });
    }

    public void removeClusterTopologyChangeListener(Listener listener) {
        this.actor.run(() -> this.topologyChangeListeners.remove(listener));
    }

    public static interface Listener {
        public void onClusterTopologyChanged(ClusterTopology var1);
    }
}

