/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.changes.TopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

final class MemberJoinApplier
implements TopologyChangeAppliers.OperationApplier {
    private final MemberId memberId;
    private final TopologyMembershipChangeExecutor topologyMembershipChangeExecutor;

    MemberJoinApplier(MemberId memberId, TopologyMembershipChangeExecutor topologyMembershipChangeExecutor) {
        this.memberId = memberId;
        this.topologyMembershipChangeExecutor = topologyMembershipChangeExecutor;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> init(ClusterTopology currentClusterTopology) {
        if (currentClusterTopology.hasMember(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join member %s, but the member is already part of the topology", this.memberId)));
        }
        return Either.right(ignore -> MemberState.uninitialized().toJoining());
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> apply() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.topologyMembershipChangeExecutor.addBroker(this.memberId).onComplete((ignore, error) -> {
            if (error == null) {
                future.complete(MemberState::toActive);
            } else {
                future.completeExceptionally(error);
            }
        });
        return future;
    }
}

