/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

record PartitionLeaveApplier(int partitionId, MemberId localMemberId, PartitionChangeExecutor partitionChangeExecutor) implements TopologyChangeAppliers.OperationApplier
{
    @Override
    public Either<Exception, UnaryOperator<MemberState>> init(ClusterTopology currentClusterTopology) {
        boolean partitionIsLeaving;
        if (!currentClusterTopology.hasMember(this.localMemberId)) {
            return Either.left((Object)new IllegalStateException("Expected to leave partition, but the local member does not exist in the topology"));
        }
        boolean partitionExistsInLocalMember = currentClusterTopology.getMember(this.localMemberId).hasPartition(this.partitionId);
        if (!partitionExistsInLocalMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to leave partition, but the local member does not have the partition %s", this.partitionId)));
        }
        boolean bl = partitionIsLeaving = currentClusterTopology.getMember(this.localMemberId).getPartition(this.partitionId).state() == PartitionState.State.LEAVING;
        if (partitionIsLeaving) {
            return Either.right(m -> m);
        }
        return Either.right(memberState -> memberState.updatePartition(this.partitionId, PartitionState::toLeaving));
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> apply() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.leave(this.partitionId).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.removePartition(this.partitionId));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }
}

