/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.state;

import com.google.common.collect.ImmutableMap;
import io.camunda.zeebe.topology.state.PartitionState;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public record MemberState(long version, Instant lastUpdated, State state, Map<Integer, PartitionState> partitions) {
    public static MemberState initializeAsActive(Map<Integer, PartitionState> initialPartitions) {
        return new MemberState(0L, Instant.now(), State.ACTIVE, Map.copyOf(initialPartitions));
    }

    public static MemberState uninitialized() {
        return new MemberState(0L, Instant.MIN, State.UNINITIALIZED, Map.of());
    }

    public MemberState toJoining() {
        if (this.state == State.JOINING) {
            return this;
        }
        if (this.state == State.LEAVING) {
            throw new IllegalStateException(String.format("Cannot transition to JOINING when current state is %s", new Object[]{this.state}));
        }
        return this.update(State.JOINING, this.partitions);
    }

    public MemberState toActive() {
        if (this.state == State.ACTIVE) {
            return this;
        }
        if (this.state == State.LEFT || this.state == State.LEAVING) {
            throw new IllegalStateException(String.format("Cannot transition to ACTIVE when current state is %s", new Object[]{this.state}));
        }
        return this.update(State.ACTIVE, this.partitions);
    }

    public MemberState toLeaving() {
        if (this.state == State.LEAVING) {
            return this;
        }
        if (this.state == State.LEFT) {
            throw new IllegalStateException(String.format("Cannot transition to LEAVING when current state is %s", new Object[]{this.state}));
        }
        return this.update(State.LEAVING, this.partitions);
    }

    public MemberState toLeft() {
        if (this.state == State.LEFT) {
            return this;
        }
        return this.update(State.LEFT, this.partitions);
    }

    public MemberState addPartition(int partitionId, PartitionState partitionState) {
        if (this.partitions.containsKey(partitionId)) {
            throw new IllegalStateException(String.format("Expected add a new partition, but partition %d already exists with state %s", partitionId, this.partitions.get(partitionId)));
        }
        return this.internalUpdatePartition(partitionId, partitionState);
    }

    public MemberState updatePartition(int partitionId, UnaryOperator<PartitionState> partitionStateUpdater) {
        if (!this.partitions.containsKey(partitionId)) {
            throw new IllegalStateException(String.format("Expected to update partition %d, but partition does not exist", partitionId));
        }
        PartitionState updatedPartitionState = (PartitionState)partitionStateUpdater.apply(this.partitions.get(partitionId));
        return this.internalUpdatePartition(partitionId, updatedPartitionState);
    }

    public MemberState removePartition(int partitionId) {
        HashMap<Integer, PartitionState> mutableMap = new HashMap<Integer, PartitionState>(this.partitions);
        mutableMap.remove(partitionId);
        ImmutableMap updatedPartitions = ImmutableMap.builder().putAll(mutableMap).build();
        return this.update(this.state, (Map<Integer, PartitionState>)updatedPartitions);
    }

    MemberState merge(MemberState other) {
        if (other == null) {
            return this;
        }
        if (this.version == other.version && !this.equals(other)) {
            throw new IllegalStateException(String.format("Expected to find same MemberState at same version, but found %s and %s", this, other));
        }
        if (this.version >= other.version) {
            return this;
        }
        return other;
    }

    private MemberState internalUpdatePartition(int partitionId, PartitionState partitionState) {
        ImmutableMap updatedPartitions = ImmutableMap.builder().putAll(this.partitions).put((Object)partitionId, (Object)partitionState).buildKeepingLast();
        return this.update(this.state, (Map<Integer, PartitionState>)updatedPartitions);
    }

    private MemberState update(State state, Map<Integer, PartitionState> partitions) {
        return new MemberState(this.version + 1L, Instant.now(), state, partitions);
    }

    public boolean hasPartition(int partitionId) {
        return this.partitions().containsKey(partitionId);
    }

    public PartitionState getPartition(int partitionId) {
        return this.partitions.get(partitionId);
    }

    public static enum State {
        UNINITIALIZED,
        JOINING,
        ACTIVE,
        LEAVING,
        LEFT;

    }
}

