/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.util;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class TopologyUtil {
    private TopologyUtil() {
    }

    public static ClusterTopology getClusterTopologyFrom(Set<PartitionMetadata> partitionDistribution) {
        HashMap<MemberId, Map> partitionStatesByMember = new HashMap<MemberId, Map>();
        for (PartitionMetadata partitionMetadata : partitionDistribution) {
            Integer partitionId = (Integer)partitionMetadata.id().id();
            for (MemberId member : partitionMetadata.members()) {
                int memberPriority = partitionMetadata.getPriority(member);
                partitionStatesByMember.computeIfAbsent(member, k -> new HashMap()).put(partitionId, PartitionState.active(memberPriority));
            }
        }
        HashMap<MemberId, MemberState> memberStates = new HashMap<MemberId, MemberState>();
        for (Map.Entry e : partitionStatesByMember.entrySet()) {
            memberStates.put((MemberId)e.getKey(), MemberState.initializeAsActive((Map)e.getValue()));
        }
        return new ClusterTopology(0L, Map.copyOf(memberStates), ClusterChangePlan.empty());
    }

    public static Set<PartitionMetadata> getPartitionDistributionFrom(ClusterTopology clusterTopology, String groupName) {
        if (clusterTopology.isUninitialized()) {
            throw new IllegalStateException("Cannot generated partition distribution from uninitialized topology");
        }
        HashMap memberPriorityByPartition = new HashMap();
        clusterTopology.members().forEach((memberId, member) -> {
            for (Map.Entry<Integer, PartitionState> entry : member.partitions().entrySet()) {
                Integer partitionId = entry.getKey();
                PartitionState partitionState = entry.getValue();
                memberPriorityByPartition.computeIfAbsent(partitionId, k -> new HashMap()).put(memberId, partitionState.priority());
            }
        });
        return memberPriorityByPartition.entrySet().stream().map(e -> TopologyUtil.getPartitionMetadata(e, groupName)).collect(Collectors.toSet());
    }

    private static PartitionMetadata getPartitionMetadata(Map.Entry<Integer, Map<MemberId, Integer>> e, String groupName) {
        Map<MemberId, Integer> memberPriorities = e.getValue();
        Optional optionalPrimary = memberPriorities.entrySet().stream().max(Map.Entry.comparingByValue());
        if (optionalPrimary.isEmpty()) {
            throw new IllegalStateException("Found partition with no members");
        }
        return new PartitionMetadata(TopologyUtil.partitionId(e.getKey(), groupName), memberPriorities.keySet(), memberPriorities, ((Integer)optionalPrimary.get().getValue()).intValue(), (MemberId)optionalPrimary.get().getKey());
    }

    private static PartitionId partitionId(Integer key, String groupName) {
        return PartitionId.from((String)groupName, (int)key);
    }
}

