/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.auth;

import com.auth0.client.HttpOptions;
import com.auth0.client.LoggingOptions;
import com.auth0.client.ProxyOptions;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import com.auth0.client.auth.LogoutUrlBuilder;
import com.auth0.client.auth.PasswordlessEmailType;
import com.auth0.json.auth.PasswordlessEmailResponse;
import com.auth0.json.auth.PasswordlessSmsResponse;
import com.auth0.json.auth.PushedAuthorizationResponse;
import com.auth0.json.auth.UserInfo;
import com.auth0.net.CreateUserRequest;
import com.auth0.net.CustomRequest;
import com.auth0.net.FormBodyRequest;
import com.auth0.net.SignUpRequest;
import com.auth0.net.Telemetry;
import com.auth0.net.TelemetryInterceptor;
import com.auth0.net.TokenRequest;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;

public class AuthAPI {
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_AUDIENCE = "audience";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_CONNECTION = "connection";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_OTP = "otp";
    private static final String KEY_REALM = "realm";
    private static final String KEY_MFA_TOKEN = "mfa_token";
    private static final String PATH_OAUTH = "oauth";
    private static final String PATH_TOKEN = "token";
    private static final String PATH_DBCONNECTIONS = "dbconnections";
    private static final String PATH_REVOKE = "revoke";
    private static final String PATH_PASSWORDLESS = "passwordless";
    private static final String PATH_START = "start";
    private final OkHttpClient client;
    private final String clientId;
    private final String clientSecret;
    private final HttpUrl baseUrl;
    private final TelemetryInterceptor telemetry;
    private final HttpLoggingInterceptor logging;

    public AuthAPI(String domain, String clientId, String clientSecret, HttpOptions options) {
        Asserts.assertNotNull(domain, "domain");
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(clientSecret, "client secret");
        Asserts.assertNotNull(options, "client options");
        this.baseUrl = this.createBaseUrl(domain);
        if (this.baseUrl == null) {
            throw new IllegalArgumentException("The domain had an invalid format and couldn't be parsed as an URL.");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.telemetry = new TelemetryInterceptor();
        this.logging = new HttpLoggingInterceptor();
        this.client = this.buildNetworkingClient(options);
    }

    public AuthAPI(String domain, String clientId, String clientSecret) {
        this(domain, clientId, clientSecret, new HttpOptions());
    }

    private OkHttpClient buildNetworkingClient(HttpOptions options) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        ProxyOptions proxyOptions = options.getProxyOptions();
        if (proxyOptions != null) {
            clientBuilder.proxy(proxyOptions.getProxy());
            final String proxyAuth = proxyOptions.getBasicAuthentication();
            if (proxyAuth != null) {
                clientBuilder.proxyAuthenticator(new Authenticator(){
                    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";

                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header(PROXY_AUTHORIZATION_HEADER) != null) {
                            return null;
                        }
                        return response.request().newBuilder().header(PROXY_AUTHORIZATION_HEADER, proxyAuth).build();
                    }
                });
            }
        }
        this.configureLogging(options.getLoggingOptions());
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(options.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(options.getMaxRequestsPerHost());
        return clientBuilder.addInterceptor((Interceptor)this.logging).addInterceptor((Interceptor)this.telemetry).connectTimeout((long)options.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)options.getReadTimeout(), TimeUnit.SECONDS).dispatcher(dispatcher).build();
    }

    public void doNotSendTelemetry() {
        this.telemetry.setEnabled(false);
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry.setTelemetry(telemetry);
    }

    @Deprecated
    public void setLoggingEnabled(boolean enabled) {
        this.logging.setLevel(enabled ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    private void configureLogging(LoggingOptions loggingOptions) {
        if (loggingOptions == null) {
            this.logging.setLevel(HttpLoggingInterceptor.Level.NONE);
            return;
        }
        switch (loggingOptions.getLogLevel()) {
            case BASIC: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case BODY: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
            default: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
        }
        for (String header : loggingOptions.getHeadersToRedact()) {
            this.logging.redactHeader(header);
        }
    }

    OkHttpClient getClient() {
        return this.client;
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    private HttpUrl createBaseUrl(String domain) {
        String url = domain;
        if (!domain.startsWith("https://") && !domain.startsWith("http://")) {
            url = "https://" + domain;
        }
        return HttpUrl.parse((String)url);
    }

    public AuthorizeUrlBuilder authorizeUrl(String redirectUri) {
        Asserts.assertValidUrl(redirectUri, "redirect uri");
        return AuthorizeUrlBuilder.newInstance(this.baseUrl, this.clientId, redirectUri);
    }

    public String authorizeUrlWithPAR(String requestUri) {
        Asserts.assertNotNull(requestUri, "request uri");
        return this.baseUrl.newBuilder().addPathSegment("authorize").addQueryParameter(KEY_CLIENT_ID, this.clientId).addQueryParameter("request_uri", requestUri).build().toString();
    }

    public com.auth0.net.Request<PushedAuthorizationResponse> pushedAuthorizationRequest(String redirectUri, String responseType, Map<String, String> params) {
        Asserts.assertValidUrl(redirectUri, "redirect uri");
        Asserts.assertNotNull(responseType, "response type");
        String url = this.baseUrl.newBuilder().addPathSegments("oauth/par").build().toString();
        FormBodyRequest<PushedAuthorizationResponse> request = new FormBodyRequest<PushedAuthorizationResponse>(this.client, url, "POST", new TypeReference<PushedAuthorizationResponse>(){});
        request.addData(KEY_CLIENT_ID, this.clientId);
        request.addData(KEY_CLIENT_SECRET, this.clientSecret);
        request.addData("redirect_uri", redirectUri);
        request.addData("response_type", responseType);
        if (params != null) {
            params.forEach(request::addData);
        }
        return request;
    }

    public LogoutUrlBuilder logoutUrl(String returnToUrl, boolean setClientId) {
        Asserts.assertValidUrl(returnToUrl, "return to url");
        return LogoutUrlBuilder.newInstance(this.baseUrl, this.clientId, returnToUrl, setClientId);
    }

    public com.auth0.net.Request<UserInfo> userInfo(String accessToken) {
        Asserts.assertNotNull(accessToken, "access token");
        String url = this.baseUrl.newBuilder().addPathSegment("userinfo").build().toString();
        CustomRequest<UserInfo> request = new CustomRequest<UserInfo>(this.client, url, "GET", new TypeReference<UserInfo>(){});
        request.addHeader("Authorization", "Bearer " + accessToken);
        return request;
    }

    public com.auth0.net.Request<Void> resetPassword(String email, String connection) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull(connection, KEY_CONNECTION);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_DBCONNECTIONS).addPathSegment("change_password").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter(KEY_CONNECTION, connection);
        return request;
    }

    @Deprecated
    public SignUpRequest signUp(String email, String username, String password, String connection) {
        return this.signUp(email, username, password != null ? password.toCharArray() : null, connection);
    }

    public SignUpRequest signUp(String email, String username, char[] password, String connection) {
        Asserts.assertNotNull(username, KEY_USERNAME);
        CreateUserRequest request = (CreateUserRequest)this.signUp(email, password, connection);
        request.addParameter(KEY_USERNAME, username);
        return request;
    }

    @Deprecated
    public SignUpRequest signUp(String email, String password, String connection) {
        return this.signUp(email, password != null ? password.toCharArray() : null, connection);
    }

    public SignUpRequest signUp(String email, char[] password, String connection) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull(password, KEY_PASSWORD);
        Asserts.assertNotNull(connection, KEY_CONNECTION);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_DBCONNECTIONS).addPathSegment("signup").build().toString();
        CreateUserRequest request = new CreateUserRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter(KEY_PASSWORD, password);
        request.addParameter(KEY_CONNECTION, connection);
        return request;
    }

    @Deprecated
    public TokenRequest login(String emailOrUsername, String password) {
        return this.login(emailOrUsername, password != null ? password.toCharArray() : null);
    }

    public TokenRequest login(String emailOrUsername, char[] password) {
        Asserts.assertNotNull(emailOrUsername, "email or username");
        Asserts.assertNotNull(password, KEY_PASSWORD);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, KEY_PASSWORD);
        request.addParameter(KEY_USERNAME, emailOrUsername);
        request.addParameter(KEY_PASSWORD, password);
        return request;
    }

    @Deprecated
    public TokenRequest login(String emailOrUsername, String password, String realm) {
        return this.login(emailOrUsername, password != null ? password.toCharArray() : null, realm);
    }

    public TokenRequest login(String emailOrUsername, char[] password, String realm) {
        Asserts.assertNotNull(emailOrUsername, "email or username");
        Asserts.assertNotNull(password, KEY_PASSWORD);
        Asserts.assertNotNull(realm, KEY_REALM);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/password-realm");
        request.addParameter(KEY_USERNAME, emailOrUsername);
        request.addParameter(KEY_PASSWORD, password);
        request.addParameter(KEY_REALM, realm);
        return request;
    }

    public TokenRequest exchangePasswordlessOtp(String emailOrPhone, String realm, char[] otp) {
        Asserts.assertNotNull(emailOrPhone, "emailOrPhone");
        Asserts.assertNotNull(realm, KEY_REALM);
        Asserts.assertNotNull(otp, KEY_OTP);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/passwordless/otp");
        request.addParameter(KEY_USERNAME, emailOrPhone);
        request.addParameter(KEY_REALM, realm);
        request.addParameter(KEY_OTP, otp);
        return request;
    }

    public TokenRequest requestToken(String audience) {
        Asserts.assertNotNull(audience, KEY_AUDIENCE);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, "client_credentials");
        request.addParameter(KEY_AUDIENCE, audience);
        return request;
    }

    public com.auth0.net.Request<Void> revokeToken(String refreshToken) {
        Asserts.assertNotNull(refreshToken, "refresh token");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment(PATH_REVOKE).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter("token", refreshToken);
        return request;
    }

    public TokenRequest renewAuth(String refreshToken) {
        Asserts.assertNotNull(refreshToken, "refresh token");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, KEY_REFRESH_TOKEN);
        request.addParameter(KEY_REFRESH_TOKEN, refreshToken);
        return request;
    }

    public TokenRequest exchangeCode(String code, String redirectUri) {
        Asserts.assertNotNull(code, "code");
        Asserts.assertNotNull(redirectUri, "redirect uri");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, "authorization_code");
        request.addParameter("code", code);
        request.addParameter("redirect_uri", redirectUri);
        return request;
    }

    public CustomRequest<PasswordlessEmailResponse> startPasswordlessEmailFlow(String email, PasswordlessEmailType type) {
        Asserts.assertNotNull(email, KEY_EMAIL);
        Asserts.assertNotNull((Object)type, "type");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_PASSWORDLESS).addPathSegment(PATH_START).build().toString();
        CustomRequest<PasswordlessEmailResponse> request = new CustomRequest<PasswordlessEmailResponse>(this.client, url, "POST", new TypeReference<PasswordlessEmailResponse>(){});
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_CONNECTION, KEY_EMAIL);
        request.addParameter(KEY_EMAIL, email);
        request.addParameter("send", type.getType());
        return request;
    }

    public CustomRequest<PasswordlessSmsResponse> startPasswordlessSmsFlow(String phoneNumber) {
        Asserts.assertNotNull(phoneNumber, "phoneNumber");
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_PASSWORDLESS).addPathSegment(PATH_START).build().toString();
        CustomRequest<PasswordlessSmsResponse> request = new CustomRequest<PasswordlessSmsResponse>(this.client, url, "POST", new TypeReference<PasswordlessSmsResponse>(){});
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_CONNECTION, "sms");
        request.addParameter("phone_number", phoneNumber);
        return request;
    }

    public TokenRequest exchangeMfaOtp(String mfaToken, char[] otp) {
        Asserts.assertNotNull(mfaToken, "mfa token");
        Asserts.assertNotNull(otp, KEY_OTP);
        String url = this.baseUrl.newBuilder().addPathSegment(PATH_OAUTH).addPathSegment("token").build().toString();
        TokenRequest request = new TokenRequest(this.client, url);
        request.addParameter(KEY_CLIENT_ID, this.clientId);
        request.addParameter(KEY_CLIENT_SECRET, this.clientSecret);
        request.addParameter(KEY_GRANT_TYPE, "http://auth0.com/oauth/grant-type/mfa-otp");
        request.addParameter(KEY_MFA_TOKEN, mfaToken);
        request.addParameter(KEY_OTP, otp);
        return request;
    }
}

