/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.branding.BrandingSettings;
import com.auth0.json.mgmt.branding.UniversalLoginTemplate;
import com.auth0.json.mgmt.branding.UniversalLoginTemplateUpdate;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class BrandingEntity
extends BaseManagementEntity {
    BrandingEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<BrandingSettings> getBrandingSettings() {
        return this.request("GET", new TypeReference<BrandingSettings>(){}, builder -> builder.withPathSegments("api/v2/branding"));
    }

    public Request<BrandingSettings> updateBrandingSettings(BrandingSettings settings) {
        Asserts.assertNotNull(settings, "settings");
        return this.request("PATCH", new TypeReference<BrandingSettings>(){}, builder -> builder.withPathSegments("api/v2/branding").withBody(settings));
    }

    public Request<UniversalLoginTemplate> getUniversalLoginTemplate() {
        return this.request("GET", new TypeReference<UniversalLoginTemplate>(){}, builder -> builder.withPathSegments("api/v2/branding/templates/universal-login"));
    }

    public Request<Void> deleteUniversalLoginTemplate() {
        return this.voidRequest("DELETE", builder -> builder.withPathSegments("api/v2/branding/templates/universal-login"));
    }

    public Request<Void> setUniversalLoginTemplate(UniversalLoginTemplateUpdate template) {
        Asserts.assertNotNull(template, "template");
        return this.voidRequest("PUT", builder -> builder.withPathSegments("api/v2/branding/templates/universal-login").withBody(template));
    }
}

