/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.ClientGrantsFilter;
import com.auth0.json.mgmt.ClientGrant;
import com.auth0.json.mgmt.ClientGrantsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ClientGrantsEntity
extends BaseManagementEntity {
    ClientGrantsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<ClientGrantsPage> list(ClientGrantsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<ClientGrantsPage> request = new CustomRequest<ClientGrantsPage>(this.client, url, "GET", new TypeReference<ClientGrantsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    @Deprecated
    public Request<List<ClientGrant>> list() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").build().toString();
        CustomRequest<List<ClientGrant>> request = new CustomRequest<List<ClientGrant>>(this.client, url, "GET", new TypeReference<List<ClientGrant>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ClientGrant> create(String clientId, String audience, String[] scope) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(audience, "audience");
        Asserts.assertNotNull(scope, "scope");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").build().toString();
        CustomRequest<ClientGrant> request = new CustomRequest<ClientGrant>(this.client, url, "POST", new TypeReference<ClientGrant>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.addParameter("client_id", clientId);
        request.addParameter("audience", audience);
        request.addParameter("scope", scope);
        return request;
    }

    public Request<Void> delete(String clientGrantId) {
        Asserts.assertNotNull(clientGrantId, "client grant id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").addPathSegment(clientGrantId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ClientGrant> update(String clientGrantId, String[] scope) {
        Asserts.assertNotNull(clientGrantId, "client grant id");
        Asserts.assertNotNull(scope, "scope");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/client-grants").addPathSegment(clientGrantId).build().toString();
        CustomRequest<ClientGrant> request = new CustomRequest<ClientGrant>(this.client, url, "PATCH", new TypeReference<ClientGrant>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.addParameter("scope", scope);
        return request;
    }
}

