/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.UsersExportFilter;
import com.auth0.client.mgmt.filter.UsersImportOptions;
import com.auth0.json.mgmt.EmailVerificationIdentity;
import com.auth0.json.mgmt.jobs.Job;
import com.auth0.json.mgmt.jobs.JobErrorDetails;
import com.auth0.net.CustomRequest;
import com.auth0.net.MultipartRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;

public class JobsEntity
extends BaseManagementEntity {
    JobsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<Job> get(String jobId) {
        Asserts.assertNotNull(jobId, "job id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs").addPathSegment(jobId).build().toString();
        CustomRequest<Job> request = new CustomRequest<Job>(this.client, url, "GET", new TypeReference<Job>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<List<JobErrorDetails>> getErrorDetails(String jobId) {
        Asserts.assertNotNull(jobId, "job id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs").addPathSegment(jobId).addPathSegment("errors").build().toString();
        TypeReference<List<JobErrorDetails>> jobErrorDetailsListType = new TypeReference<List<JobErrorDetails>>(){};
        CustomRequest<List<JobErrorDetails>> request = new CustomRequest<List<JobErrorDetails>>(this.client, url, "GET", (TypeReference)jobErrorDetailsListType){

            @Override
            protected List<JobErrorDetails> readResponseBody(ResponseBody body) throws IOException {
                if (body.contentLength() == 0L) {
                    return Collections.emptyList();
                }
                return (List)super.readResponseBody(body);
            }
        };
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId) {
        return this.sendVerificationEmail(userId, clientId, null);
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId, EmailVerificationIdentity emailVerificationIdentity) {
        return this.sendVerificationEmail(userId, clientId, emailVerificationIdentity, null);
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId, EmailVerificationIdentity emailVerificationIdentity, String orgId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/verification-email").build().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("user_id", userId);
        if (clientId != null && !clientId.isEmpty()) {
            requestBody.put("client_id", clientId);
        }
        if (orgId != null && !orgId.isEmpty()) {
            requestBody.put("organization_id", orgId);
        }
        if (emailVerificationIdentity != null) {
            Asserts.assertNotNull(emailVerificationIdentity.getProvider(), "identity provider");
            Asserts.assertNotNull(emailVerificationIdentity.getUserId(), "identity user id");
            requestBody.put("identity", emailVerificationIdentity);
        }
        CustomRequest<Job> request = new CustomRequest<Job>(this.client, url, "POST", new TypeReference<Job>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(requestBody);
        return request;
    }

    public Request<Job> exportUsers(String connectionId, UsersExportFilter filter) {
        Asserts.assertNotNull(connectionId, "connection id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/users-exports").build().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("connection_id", connectionId);
        if (filter != null) {
            requestBody.putAll(filter.getAsMap());
        }
        CustomRequest<Job> request = new CustomRequest<Job>(this.client, url, "POST", new TypeReference<Job>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(requestBody);
        return request;
    }

    public Request<Job> importUsers(String connectionId, File users, UsersImportOptions options) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(users, "users file");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/users-imports").build().toString();
        MultipartRequest<Job> request = new MultipartRequest<Job>(this.client, url, "POST", new TypeReference<Job>(){});
        if (options != null) {
            for (Map.Entry<String, Object> e : options.getAsMap().entrySet()) {
                request.addPart(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        request.addPart("connection_id", connectionId);
        request.addPart("users", users, "text/json");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

