/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.RulesConfig;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class RulesConfigsEntity
extends BaseManagementEntity {
    RulesConfigsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<RulesConfig>> list() {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs");
        String url = builder.build().toString();
        CustomRequest<List<RulesConfig>> request = new CustomRequest<List<RulesConfig>>(this.client, url, "GET", new TypeReference<List<RulesConfig>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> delete(String rulesConfigKey) {
        Asserts.assertNotNull(rulesConfigKey, "rules config key");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs").addPathSegment(rulesConfigKey).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<RulesConfig> update(String rulesConfigKey, RulesConfig rulesConfig) {
        Asserts.assertNotNull(rulesConfigKey, "rules config key");
        Asserts.assertNotNull(rulesConfig, "rules config");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules-configs").addPathSegment(rulesConfigKey).build().toString();
        CustomRequest<RulesConfig> request = new CustomRequest<RulesConfig>(this.client, url, "PUT", new TypeReference<RulesConfig>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(rulesConfig);
        return request;
    }
}

