/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt.filter;

import com.auth0.client.mgmt.filter.FieldsFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class QueryFilter
extends FieldsFilter {
    public static final String KEY_QUERY = "q";

    public QueryFilter withQuery(String query) {
        try {
            String encodedQuery = this.urlEncode(query);
            this.parameters.put(KEY_QUERY, encodedQuery);
            return this;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 encoding not supported by current Java platform implementation.", ex);
        }
    }

    public QueryFilter withTotals(boolean includeTotals) {
        this.parameters.put("include_totals", includeTotals);
        return this;
    }

    public QueryFilter withSort(String sort) {
        this.parameters.put("sort", sort);
        return this;
    }

    public QueryFilter withPage(int pageNumber, int amountPerPage) {
        this.parameters.put("page", pageNumber);
        this.parameters.put("per_page", amountPerPage);
        return this;
    }

    @Override
    public QueryFilter withFields(String fields, boolean includeFields) {
        super.withFields(fields, includeFields);
        return this;
    }

    String urlEncode(String query) throws UnsupportedEncodingException {
        return URLEncoder.encode(query, "UTF-8");
    }
}

