/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import java.io.IOException;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class RateLimitInterceptor
implements Interceptor {
    private final int maxRetries;
    private final CheckedConsumer<? extends ExecutionAttemptedEvent<Response>> retryListener;
    static final Long INITIAL_INTERVAL = 100L;
    static final Long MAX_INTERVAL = 1000L;
    static final Double JITTER = 0.2;

    public RateLimitInterceptor(int maxRetries) {
        this(maxRetries, null);
    }

    RateLimitInterceptor(int maxRetries, CheckedConsumer<? extends ExecutionAttemptedEvent<Response>> retryListener) {
        this.maxRetries = maxRetries;
        this.retryListener = retryListener;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        RetryPolicy retryPolicy = (RetryPolicy)new RetryPolicy().withMaxRetries(this.maxRetries).withBackoff(INITIAL_INTERVAL.longValue(), MAX_INTERVAL.longValue(), ChronoUnit.MILLIS).withJitter(JITTER.doubleValue()).handleResultIf(response -> {
            if (response.code() == 429) {
                response.close();
                return true;
            }
            return false;
        });
        if (this.retryListener != null) {
            retryPolicy.onRetry(this.retryListener);
        }
        return (Response)Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get(() -> chain.proceed(chain.request()));
    }
}

