/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.jobstream.JobStreamService;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class SpringBrokerBridge {
    private Supplier<BrokerHealthCheckService> healthCheckServiceSupplier;
    private Supplier<BrokerAdminService> adminServiceSupplier;
    private Supplier<JobStreamService> jobStreamServiceSupplier;
    private Supplier<JobStreamClient> jobStreamClientSupplier;

    public void registerBrokerHealthCheckServiceSupplier(Supplier<BrokerHealthCheckService> healthCheckServiceSupplier) {
        this.healthCheckServiceSupplier = healthCheckServiceSupplier;
    }

    public Optional<BrokerHealthCheckService> getBrokerHealthCheckService() {
        return Optional.ofNullable(this.healthCheckServiceSupplier).map(Supplier::get);
    }

    public void registerBrokerAdminServiceSupplier(Supplier<BrokerAdminService> adminServiceSupplier) {
        this.adminServiceSupplier = adminServiceSupplier;
    }

    public Optional<BrokerAdminService> getAdminService() {
        return Optional.ofNullable(this.adminServiceSupplier).map(Supplier::get);
    }

    public void registerJobStreamClientSupplier(Supplier<JobStreamClient> jobStreamClientSupplier) {
        this.jobStreamClientSupplier = jobStreamClientSupplier;
    }

    public Optional<JobStreamClient> getJobStreamClient() {
        return Optional.ofNullable(this.jobStreamClientSupplier).map(Supplier::get);
    }

    public void registerJobStreamServiceSupplier(Supplier<JobStreamService> jobStreamServiceSupplier) {
        this.jobStreamServiceSupplier = jobStreamServiceSupplier;
    }

    public Optional<JobStreamService> getJobStreamService() {
        return Optional.ofNullable(this.jobStreamServiceSupplier).map(Supplier::get);
    }
}

