/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.partitioning.PartitionManager;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import java.util.Objects;

final class BrokerContextImpl
implements BrokerContext {
    private final ClusterServicesImpl clusterServices;
    private final EmbeddedGatewayService embeddedGatewayService;
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final PartitionManager partitionManager;
    private final BrokerAdminService brokerAdminService;

    BrokerContextImpl(DiskSpaceUsageMonitor diskSpaceUsageMonitor, ClusterServicesImpl clusterServices, EmbeddedGatewayService embeddedGatewayService, PartitionManager partitionManager, BrokerAdminService brokerAdminService) {
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        this.clusterServices = Objects.requireNonNull(clusterServices);
        this.embeddedGatewayService = embeddedGatewayService;
        this.partitionManager = Objects.requireNonNull(partitionManager);
        this.brokerAdminService = Objects.requireNonNull(brokerAdminService);
    }

    @Override
    public ClusterServicesImpl getClusterServices() {
        return this.clusterServices;
    }

    @Override
    public EmbeddedGatewayService getEmbeddedGatewayService() {
        return this.embeddedGatewayService;
    }

    @Override
    public DiskSpaceUsageMonitor getDiskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public BrokerAdminService getBrokerAdminService() {
        return this.brokerAdminService;
    }
}

