/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.ClusterTopologyService;
import io.camunda.zeebe.broker.partitioning.topology.DynamicClusterTopologyService;
import io.camunda.zeebe.broker.partitioning.topology.StaticClusterTopologyService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;

public class ClusterTopologyManagerStep
implements StartupStep<BrokerStartupContext> {
    public String getName() {
        return "Cluster Topology Manager";
    }

    public ActorFuture<BrokerStartupContext> startup(BrokerStartupContext brokerStartupContext) {
        ActorFuture started = brokerStartupContext.getConcurrencyControl().createFuture();
        ClusterTopologyService clusterTopologyService = ClusterTopologyManagerStep.getClusterTopologyService(brokerStartupContext.getBrokerConfiguration());
        clusterTopologyService.start(brokerStartupContext).onComplete((ignore, error) -> {
            if (error == null) {
                brokerStartupContext.setClusterTopology(clusterTopologyService);
                started.complete((Object)brokerStartupContext);
            } else {
                started.completeExceptionally(error);
            }
        });
        return started;
    }

    public ActorFuture<BrokerStartupContext> shutdown(BrokerStartupContext brokerStartupContext) {
        ActorFuture stopFuture = brokerStartupContext.getConcurrencyControl().createFuture();
        ClusterTopologyService clusterTopologyService = brokerStartupContext.getClusterTopology();
        if (clusterTopologyService != null) {
            clusterTopologyService.closeAsync().onComplete((ignore, error) -> {
                if (error == null) {
                    brokerStartupContext.setClusterTopology(null);
                    stopFuture.complete((Object)brokerStartupContext);
                } else {
                    stopFuture.completeExceptionally(error);
                }
            });
        } else {
            stopFuture.complete((Object)brokerStartupContext);
        }
        return stopFuture;
    }

    private static ClusterTopologyService getClusterTopologyService(BrokerCfg brokerConfiguration) {
        return brokerConfiguration.getExperimental().getFeatures().isEnableDynamicClusterTopology() ? new DynamicClusterTopologyService() : new StaticClusterTopologyService();
    }
}

