/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;

final class MonitoringServerStep
extends AbstractBrokerStartupStep {
    MonitoringServerStep() {
    }

    public String getName() {
        return "Health Monitor";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerHealthCheckService healthCheckService = brokerStartupContext.getHealthCheckService();
        concurrencyControl.runOnCompletion(brokerStartupContext.getActorSchedulingService().submitActor((Actor)healthCheckService), (ok, error) -> this.forwardExceptions(() -> this.completeStartup(brokerStartupContext, startupFuture, healthCheckService, (Throwable)error), startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        BrokerHealthCheckService healthCheckService = brokerShutdownContext.getHealthCheckService();
        SpringBrokerBridge springBrokerBridge = brokerShutdownContext.getSpringBrokerBridge();
        springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> null);
        brokerShutdownContext.removePartitionRaftListener(healthCheckService);
        concurrencyControl.runOnCompletion(healthCheckService.closeAsync(), (ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                shutdownFuture.complete((Object)brokerShutdownContext);
            }
        });
    }

    private void completeStartup(BrokerStartupContext brokerStartupContext, ActorFuture<BrokerStartupContext> startupFuture, BrokerHealthCheckService healthCheckService, Throwable error) {
        if (error != null) {
            startupFuture.completeExceptionally(error);
        } else {
            SpringBrokerBridge springBrokerBridge = brokerStartupContext.getSpringBrokerBridge();
            springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> healthCheckService);
            brokerStartupContext.addPartitionRaftListener(healthCheckService);
            startupFuture.complete((Object)brokerStartupContext);
        }
    }
}

