/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.PartitionRaftListener;
import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.partitioning.Partition;
import io.camunda.zeebe.broker.partitioning.PartitionManager;
import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.broker.partitioning.startup.RaftPartitionFactory;
import io.camunda.zeebe.broker.partitioning.startup.ZeebePartitionFactory;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManagerImpl;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.FeatureFlags;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartitionManagerImpl
implements PartitionManager,
PartitionChangeExecutor {
    public static final String GROUP_NAME = "raft-partition";
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManagerImpl.class);
    private final ConcurrencyControl concurrencyControl;
    private final BrokerHealthCheckService healthCheckService;
    private final ActorSchedulingService actorSchedulingService;
    private final TopologyManagerImpl topologyManager;
    private final Map<Integer, Partition> partitions = new ConcurrentHashMap<Integer, Partition>();
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final PartitionDistribution partitionDistribution;
    private final DefaultPartitionManagementService managementService;
    private final BrokerCfg brokerCfg;
    private final ZeebePartitionFactory zeebePartitionFactory;
    private final RaftPartitionFactory raftPartitionFactory;

    public PartitionManagerImpl(ConcurrencyControl concurrencyControl, ActorSchedulingService actorSchedulingService, BrokerCfg brokerCfg, BrokerInfo localBroker, ClusterServices clusterServices, BrokerHealthCheckService healthCheckService, DiskSpaceUsageMonitor diskSpaceUsageMonitor, List<PartitionListener> partitionListeners, List<PartitionRaftListener> partitionRaftListeners, CommandApiService commandApiService, ExporterRepository exporterRepository, AtomixServerTransport gatewayBrokerTransport, JobStreamer jobStreamer, PartitionDistribution partitionDistribution) {
        this.brokerCfg = brokerCfg;
        this.concurrencyControl = concurrencyControl;
        this.actorSchedulingService = actorSchedulingService;
        this.healthCheckService = healthCheckService;
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        FeatureFlags featureFlags = brokerCfg.getExperimental().getFeatures().toFeatureFlags();
        this.partitionDistribution = partitionDistribution;
        this.topologyManager = new TopologyManagerImpl(clusterServices.getMembershipService(), localBroker);
        ArrayList<PartitionListener> listeners = new ArrayList<PartitionListener>(partitionListeners);
        listeners.add(this.topologyManager);
        this.zeebePartitionFactory = new ZeebePartitionFactory(actorSchedulingService, brokerCfg, localBroker, commandApiService, clusterServices, exporterRepository, diskSpaceUsageMonitor, gatewayBrokerTransport, jobStreamer, listeners, partitionRaftListeners, this.topologyManager, featureFlags);
        this.managementService = new DefaultPartitionManagementService(clusterServices.getMembershipService(), clusterServices.getCommunicationService());
        this.raftPartitionFactory = new RaftPartitionFactory(brokerCfg);
    }

    public void start() {
        this.actorSchedulingService.submitActor((Actor)this.topologyManager);
        MemberId localMemberId = this.managementService.getMembershipService().getLocalMember().id();
        List<PartitionMetadata> memberPartitions = this.partitionDistribution.partitions().stream().filter(p -> p.members().contains(localMemberId)).toList();
        this.healthCheckService.registerBootstrapPartitions(memberPartitions);
        for (PartitionMetadata partitionMetadata : memberPartitions) {
            this.bootstrapPartition(partitionMetadata);
        }
    }

    private ActorFuture<Void> bootstrapPartition(PartitionMetadata partitionMetadata) {
        ActorFuture result = this.concurrencyControl.createFuture();
        Integer id = (Integer)partitionMetadata.id().id();
        PartitionStartupContext context = new PartitionStartupContext(this.actorSchedulingService, this.concurrencyControl, this.topologyManager, this.diskSpaceUsageMonitor, this.healthCheckService, (PartitionManagementService)this.managementService, partitionMetadata, this.raftPartitionFactory, this.zeebePartitionFactory, this.brokerCfg);
        Partition partition = Partition.bootstrapping(context);
        this.partitions.put(id, partition);
        this.concurrencyControl.runOnCompletion(partition.start(), (started, error) -> this.completePartitionStart(id, (Throwable)error, (ActorFuture<Void>)result));
        return result;
    }

    private ActorFuture<Void> joinPartition(PartitionMetadata partitionMetadata) {
        PartitionStartupContext context;
        Partition partition;
        ActorFuture result = this.concurrencyControl.createFuture();
        Integer id = (Integer)partitionMetadata.id().id();
        Partition previousPartition = this.partitions.putIfAbsent(id, partition = Partition.joining(context = new PartitionStartupContext(this.actorSchedulingService, this.concurrencyControl, this.topologyManager, this.diskSpaceUsageMonitor, this.healthCheckService, (PartitionManagementService)this.managementService, partitionMetadata, this.raftPartitionFactory, this.zeebePartitionFactory, this.brokerCfg)));
        if (previousPartition != null) {
            result.completeExceptionally((Throwable)new IllegalStateException(String.format("Partition %d already exists", id)));
            return result;
        }
        this.concurrencyControl.run(() -> this.concurrencyControl.runOnCompletion(partition.start(), (started, error) -> this.completePartitionStart(id, (Throwable)error, (ActorFuture<Void>)result)));
        return result;
    }

    private void completePartitionStart(int partitionId, Throwable error, ActorFuture<Void> future) {
        if (error != null) {
            LOGGER.error("Failed to start partition {}", (Object)partitionId, (Object)error);
            this.topologyManager.onHealthChanged(partitionId, HealthStatus.DEAD);
            future.completeExceptionally(error);
            return;
        }
        LOGGER.info("Started partition {}", (Object)partitionId);
        future.complete(null);
    }

    public ActorFuture<Void> stop() {
        ActorFuture result = this.concurrencyControl.createFuture();
        ActorFuture stop = (ActorFuture)this.partitions.values().stream().map(Partition::stop).collect(new ActorFutureCollector(this.concurrencyControl));
        this.concurrencyControl.runOnCompletion(stop, (ok, error) -> {
            if (error != null) {
                LOGGER.error("Failed to stop partitions", error);
                result.completeExceptionally(error);
            } else {
                this.partitions.clear();
                this.topologyManager.closeAsync().onComplete((BiConsumer)result);
            }
        });
        return result;
    }

    public String toString() {
        return "PartitionManagerImpl{partitions=" + this.partitions + "}";
    }

    @Override
    public RaftPartition getRaftPartition(int partitionId) {
        return this.partitions.get(partitionId).raftPartition();
    }

    @Override
    public Collection<RaftPartition> getRaftPartitions() {
        return this.partitions.values().stream().map(Partition::raftPartition).toList();
    }

    @Override
    public Collection<ZeebePartition> getZeebePartitions() {
        return this.partitions.values().stream().map(Partition::zeebePartition).toList();
    }

    public ActorFuture<Void> join(int partitionId, Map<MemberId, Integer> membersWithPriority) {
        int targetPriority = Collections.max(membersWithPriority.values());
        Set<MemberId> members = membersWithPriority.keySet();
        List<MemberId> primaries = membersWithPriority.entrySet().stream().filter(entry -> (Integer)entry.getValue() == targetPriority).map(Map.Entry::getKey).toList();
        MemberId primary = null;
        if (primaries.size() == 1) {
            primary = primaries.get(0);
        }
        PartitionMetadata partitionMetadata = new PartitionMetadata(PartitionId.from((String)GROUP_NAME, (int)partitionId), members, membersWithPriority, targetPriority, primary);
        return this.joinPartition(partitionMetadata);
    }

    public ActorFuture<Void> leave(int partitionId) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

