/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;

public final class ProcessingCfg
implements ConfigurationEntry {
    private static final int DEFAULT_PROCESSING_BATCH_LIMIT = 100;
    private Integer maxCommandsInBatch = 100;
    private boolean enableAsyncScheduledTasks = true;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        if (this.maxCommandsInBatch < 1) {
            throw new IllegalArgumentException("maxCommandsInBatch must be >= 1 but was %s".formatted(this.maxCommandsInBatch));
        }
    }

    public int getMaxCommandsInBatch() {
        return this.maxCommandsInBatch;
    }

    public void setMaxCommandsInBatch(int maxCommandsInBatch) {
        this.maxCommandsInBatch = maxCommandsInBatch;
    }

    public boolean isEnableAsyncScheduledTasks() {
        return this.enableAsyncScheduledTasks;
    }

    public void setEnableAsyncScheduledTasks(boolean enableAsyncScheduledTasks) {
        this.enableAsyncScheduledTasks = enableAsyncScheduledTasks;
    }

    public String toString() {
        return "ProcessingCfg{maxCommandsInBatch=" + this.maxCommandsInBatch + ", enableAsyncScheduledTasks=" + this.enableAsyncScheduledTasks + "}";
    }
}

