/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.PartitionRaftListener;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.health.CriticalComponentsHealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerHealthCheckService
extends Actor
implements PartitionRaftListener {
    private static final String PARTITION_COMPONENT_NAME_FORMAT = "Partition-%d";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private Map<Integer, Boolean> partitionInstallStatus;
    private volatile boolean allPartitionsInstalled = false;
    private volatile boolean brokerStarted = false;
    private final HealthMonitor healthMonitor;
    private final MemberId nodeId;

    public BrokerHealthCheckService(BrokerInfo localBroker) {
        this.nodeId = MemberId.from((String)String.valueOf(localBroker.getNodeId()));
        this.healthMonitor = new CriticalComponentsHealthMonitor("Broker-" + this.nodeId, this.actor, LOG);
    }

    public void registerBootstrapPartitions(Collection<PartitionMetadata> partitions) {
        this.partitionInstallStatus = partitions.stream().collect(Collectors.toMap(metadata -> (Integer)metadata.id().id(), p -> false));
        partitions.forEach(metadata -> this.healthMonitor.monitorComponent(String.format(PARTITION_COMPONENT_NAME_FORMAT, metadata.id().id())));
    }

    boolean isBrokerReady() {
        return this.brokerStarted && this.allPartitionsInstalled;
    }

    @Override
    public void onBecameRaftFollower(int partitionId, long term) {
        this.checkState();
        this.updateBrokerReadyStatus(partitionId);
    }

    @Override
    public void onBecameRaftLeader(int partitionId, long term) {
        this.checkState();
        this.updateBrokerReadyStatus(partitionId);
    }

    private void checkState() {
        if (this.partitionInstallStatus == null) {
            throw new IllegalStateException("PartitionInstallStatus must not be null.");
        }
    }

    private ActorFuture<Void> updateBrokerReadyStatus(int partitionId) {
        return this.actor.call(() -> {
            if (!this.allPartitionsInstalled) {
                this.partitionInstallStatus.put(partitionId, true);
                boolean bl = this.allPartitionsInstalled = !this.partitionInstallStatus.containsValue(false);
                if (this.allPartitionsInstalled) {
                    LOG.info("All partitions are installed. Broker is ready!");
                }
            }
        });
    }

    public String getName() {
        return "HealthCheckService";
    }

    protected void onActorStarted() {
        this.healthMonitor.startMonitoring();
    }

    private void registerComponent(String componentName, HealthMonitorable component) {
        this.actor.run(() -> this.healthMonitor.registerComponent(componentName, component));
    }

    public void registerMonitoredPartition(int partitionId, HealthMonitorable partition) {
        String componentName = String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId);
        this.registerComponent(componentName, partition);
    }

    public void removeMonitoredPartition(int partitionId) {
        String componentName = String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId);
        this.removeComponent(componentName);
    }

    private void removeComponent(String componentName) {
        this.actor.run(() -> this.healthMonitor.removeComponent(componentName));
    }

    public boolean isBrokerHealthy() {
        return !this.actor.isClosed() && this.getBrokerHealth() == HealthStatus.HEALTHY;
    }

    private HealthStatus getBrokerHealth() {
        if (!this.isBrokerReady()) {
            return HealthStatus.UNHEALTHY;
        }
        return this.healthMonitor.getHealthReport().getStatus();
    }

    public void setBrokerStarted() {
        this.actor.run(() -> {
            this.brokerStarted = true;
        });
    }

    public boolean isBrokerStarted() {
        return this.brokerStarted;
    }
}

