/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MonitoringRestController {
    private static final String BROKER_READY_STATUS_URI = "/ready";
    private static final String BROKER_STARTUP_STATUS_URI = "/startup";
    private static final String BROKER_HEALTH_STATUS_URI = "/health";
    @Autowired
    private SpringBrokerBridge springBrokerBridge;

    @GetMapping(value={"/health"})
    public ResponseEntity<String> health() {
        boolean brokerHealthy = this.springBrokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerHealthy).orElse(false);
        HttpStatus status = brokerHealthy ? HttpStatus.NO_CONTENT : HttpStatus.SERVICE_UNAVAILABLE;
        return new ResponseEntity((HttpStatusCode)status);
    }

    @GetMapping(value={"/ready"})
    public ResponseEntity<String> ready() {
        boolean brokerReady = this.springBrokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerReady).orElse(false);
        HttpStatus status = brokerReady ? HttpStatus.NO_CONTENT : HttpStatus.SERVICE_UNAVAILABLE;
        return new ResponseEntity((HttpStatusCode)status);
    }

    @GetMapping(value={"/startup"})
    public ResponseEntity<String> startup() {
        boolean brokerStarted = this.springBrokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerStarted).orElse(false);
        HttpStatus status = brokerStarted ? HttpStatus.NO_CONTENT : HttpStatus.SERVICE_UNAVAILABLE;
        return new ResponseEntity((HttpStatusCode)status);
    }
}

