/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
final class BrokerClientConfiguration {
    private final BrokerCfg config;
    private final AtomixCluster cluster;
    private final ActorScheduler scheduler;

    @Autowired
    BrokerClientConfiguration(BrokerCfg config, AtomixCluster cluster, ActorScheduler scheduler) {
        this.config = config;
        this.cluster = cluster;
        this.scheduler = scheduler;
    }

    @Bean(destroyMethod="close")
    BrokerClient brokerClient() {
        return new BrokerClientImpl(this.config.getGateway().getCluster().getRequestTimeout(), this.cluster.getMessagingService(), this.cluster.getMembershipService(), this.cluster.getEventService(), this.cluster.getCommunicationService(), (ActorSchedulingService)this.scheduler);
    }
}

