/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.shared.WorkingDirectoryConfiguration;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.shared.MainSupport;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(proxyBeanMethods=false, scanBasePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
public class StandaloneBroker
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOGGER = Loggers.SYSTEM_LOGGER;
    private final BrokerCfg configuration;
    private final WorkingDirectoryConfiguration.WorkingDirectory workingDirectory;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorScheduler actorScheduler;
    private final AtomixCluster cluster;
    private final BrokerClient brokerClient;
    private Broker broker;

    @Autowired
    public StandaloneBroker(BrokerCfg configuration, WorkingDirectoryConfiguration.WorkingDirectory workingDirectory, SpringBrokerBridge springBrokerBridge, ActorScheduler actorScheduler, AtomixCluster cluster, BrokerClient brokerClient) {
        this.configuration = configuration;
        this.workingDirectory = workingDirectory;
        this.springBrokerBridge = springBrokerBridge;
        this.actorScheduler = actorScheduler;
        this.cluster = cluster;
        this.brokerClient = brokerClient;
    }

    public static void main(String[] args) {
        MainSupport.setDefaultGlobalConfiguration();
        MainSupport.putSystemPropertyIfAbsent("spring.banner.location", "classpath:/assets/zeebe_broker_banner.txt");
        SpringApplication application = MainSupport.createDefaultApplicationBuilder().sources(new Class[]{StandaloneBroker.class}).profiles(new String[]{Profile.BROKER.getId()}).build(args);
        application.run(new String[0]);
    }

    public void run(String ... args) throws IOException {
        SystemContext systemContext = new SystemContext(this.configuration, this.actorScheduler, this.cluster);
        this.actorScheduler.start();
        this.brokerClient.start();
        this.broker = new Broker(systemContext, this.springBrokerBridge);
        this.broker.start();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            this.broker.close();
        }
        finally {
            this.cleanupWorkingDirectory();
        }
    }

    private void cleanupWorkingDirectory() {
        if (!this.workingDirectory.isTemporary()) {
            return;
        }
        LOGGER.debug("Deleting broker temporary working directory {}", (Object)this.workingDirectory.path());
        try {
            FileUtil.deleteFolderIfExists((Path)this.workingDirectory.path());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete temporary directory {}", (Object)this.workingDirectory.path());
        }
    }
}

