/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import io.camunda.zeebe.shared.IdleStrategyConfig;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public final class ActorSchedulerConfiguration {
    private final GatewayCfg config;
    private final ActorClockConfiguration clockConfiguration;

    @Autowired
    public ActorSchedulerConfiguration(GatewayCfg config, ActorClockConfiguration clockConfiguration) {
        this.config = config;
        this.clockConfiguration = clockConfiguration;
    }

    @Bean(destroyMethod="close")
    public ActorScheduler actorScheduler(IdleStrategyConfig.IdleStrategySupplier idleStrategySupplier) {
        return ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(this.config.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setSchedulerName("Gateway-%s".formatted(this.config.getCluster().getMemberId())).setActorClock((ActorClock)this.clockConfiguration.getClock().orElse(null)).setIdleStrategySupplier((Supplier)idleStrategySupplier).build();
    }
}

