/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;

public class ElasticsearchExporterConfiguration {
    private static final String DEFAULT_URL = "http://localhost:9200";
    public String url = "http://localhost:9200";
    public int requestTimeoutMs = 30000;
    public final IndexConfiguration index = new IndexConfiguration();
    public final BulkConfiguration bulk = new BulkConfiguration();
    public final RetentionConfiguration retention = new RetentionConfiguration();
    private final AuthenticationConfiguration authentication = new AuthenticationConfiguration();

    public boolean hasAuthenticationPresent() {
        return this.getAuthentication().isPresent();
    }

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public String toString() {
        return "ElasticsearchExporterConfiguration{url='" + this.url + "', requestTimeoutMs=" + this.requestTimeoutMs + ", index=" + this.index + ", bulk=" + this.bulk + ", retention=" + this.retention + ", authentication=" + this.authentication + "}";
    }

    public boolean shouldIndexRecord(Record<?> record) {
        return this.shouldIndexRecordType(record.getRecordType()) && this.shouldIndexValueType(record.getValueType());
    }

    public boolean shouldIndexValueType(ValueType valueType) {
        switch (valueType) {
            case DEPLOYMENT: {
                return this.index.deployment;
            }
            case PROCESS: {
                return this.index.process;
            }
            case ERROR: {
                return this.index.error;
            }
            case INCIDENT: {
                return this.index.incident;
            }
            case JOB: {
                return this.index.job;
            }
            case JOB_BATCH: {
                return this.index.jobBatch;
            }
            case MESSAGE: {
                return this.index.message;
            }
            case MESSAGE_BATCH: {
                return this.index.messageBatch;
            }
            case MESSAGE_SUBSCRIPTION: {
                return this.index.messageSubscription;
            }
            case VARIABLE: {
                return this.index.variable;
            }
            case VARIABLE_DOCUMENT: {
                return this.index.variableDocument;
            }
            case PROCESS_INSTANCE: {
                return this.index.processInstance;
            }
            case PROCESS_INSTANCE_BATCH: {
                return this.index.processInstanceBatch;
            }
            case PROCESS_INSTANCE_CREATION: {
                return this.index.processInstanceCreation;
            }
            case PROCESS_INSTANCE_MODIFICATION: {
                return this.index.processInstanceModification;
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return this.index.processMessageSubscription;
            }
            case DECISION_REQUIREMENTS: {
                return this.index.decisionRequirements;
            }
            case DECISION: {
                return this.index.decision;
            }
            case DECISION_EVALUATION: {
                return this.index.decisionEvaluation;
            }
            case CHECKPOINT: {
                return this.index.checkpoint;
            }
            case TIMER: {
                return this.index.timer;
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return this.index.messageStartEventSubscription;
            }
            case PROCESS_EVENT: {
                return this.index.processEvent;
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return this.index.deploymentDistribution;
            }
            case ESCALATION: {
                return this.index.escalation;
            }
            case SIGNAL: {
                return this.index.signal;
            }
            case SIGNAL_SUBSCRIPTION: {
                return this.index.signalSubscription;
            }
            case RESOURCE_DELETION: {
                return this.index.resourceDeletion;
            }
            case COMMAND_DISTRIBUTION: {
                return this.index.commandDistribution;
            }
            case FORM: {
                return this.index.form;
            }
        }
        return false;
    }

    public boolean shouldIndexRecordType(RecordType recordType) {
        switch (recordType) {
            case EVENT: {
                return this.index.event;
            }
            case COMMAND: {
                return this.index.command;
            }
            case COMMAND_REJECTION: {
                return this.index.rejection;
            }
        }
        return false;
    }

    public static class IndexConfiguration {
        public String prefix = "zeebe-record";
        public boolean createTemplate = true;
        public boolean command = false;
        public boolean event = true;
        public boolean rejection = false;
        public boolean decision = true;
        public boolean decisionEvaluation = true;
        public boolean decisionRequirements = true;
        public boolean deployment = true;
        public boolean error = true;
        public boolean incident = true;
        public boolean job = true;
        public boolean jobBatch = false;
        public boolean message = true;
        public boolean messageBatch = false;
        public boolean messageSubscription = true;
        public boolean process = true;
        public boolean processInstance = true;
        public boolean processInstanceBatch = false;
        public boolean processInstanceCreation = true;
        public boolean processInstanceModification = true;
        public boolean processMessageSubscription = true;
        public boolean variable = true;
        public boolean variableDocument = true;
        public boolean checkpoint = false;
        public boolean timer = true;
        public boolean messageStartEventSubscription = true;
        public boolean processEvent = false;
        public boolean deploymentDistribution = true;
        public boolean escalation = true;
        public boolean signal = true;
        public boolean signalSubscription = true;
        public boolean resourceDeletion = true;
        public boolean commandDistribution = true;
        public boolean form = true;
        private Integer numberOfShards = null;
        private Integer numberOfReplicas = null;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public Integer getNumberOfReplicas() {
            return this.numberOfReplicas;
        }

        public void setNumberOfReplicas(Integer numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
        }

        public String toString() {
            return "IndexConfiguration{prefix='" + this.prefix + "', createTemplate=" + this.createTemplate + ", command=" + this.command + ", event=" + this.event + ", rejection=" + this.rejection + ", decision=" + this.decision + ", decisionEvaluation=" + this.decisionEvaluation + ", decisionRequirements=" + this.decisionRequirements + ", deployment=" + this.deployment + ", error=" + this.error + ", incident=" + this.incident + ", job=" + this.job + ", jobBatch=" + this.jobBatch + ", message=" + this.message + ", messageBatch=" + this.messageBatch + ", messageSubscription=" + this.messageSubscription + ", process=" + this.process + ", processInstance=" + this.processInstance + ", processInstanceBatch=" + this.processInstanceBatch + ", processInstanceCreation=" + this.processInstanceCreation + ", processInstanceModification=" + this.processInstanceModification + ", processMessageSubscription=" + this.processMessageSubscription + ", variable=" + this.variable + ", variableDocument=" + this.variableDocument + ", checkpoint=" + this.checkpoint + ", timer=" + this.timer + ", messageStartEventSubscription=" + this.messageStartEventSubscription + ", processEvent=" + this.processEvent + ", deploymentDistribution=" + this.deploymentDistribution + ", escalation=" + this.escalation + ", signal=" + this.signal + ", signalSubscription=" + this.signalSubscription + ", resourceDeletion=" + this.resourceDeletion + ", commandDistribution=" + this.commandDistribution + ", form=" + this.form + "}";
        }
    }

    public static class BulkConfiguration {
        public int delay = 5;
        public int size = 1000;
        public int memoryLimit = 0xA00000;

        public String toString() {
            return "BulkConfiguration{delay=" + this.delay + ", size=" + this.size + ", memoryLimit=" + this.memoryLimit + "}";
        }
    }

    public static class RetentionConfiguration {
        private boolean enabled = false;
        private String minimumAge = "30d";
        private String policyName = "zeebe-record-retention-policy";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMinimumAge() {
            return this.minimumAge;
        }

        public void setMinimumAge(String minimumAge) {
            this.minimumAge = minimumAge;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String toString() {
            return "RetentionConfiguration{isEnabled=" + this.enabled + ", minimumAge=" + this.minimumAge + ", policyName='" + this.policyName + "'}";
        }
    }

    public static class AuthenticationConfiguration {
        private String username;
        private String password;

        public boolean isPresent() {
            return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "AuthenticationConfiguration{Confidential information}";
        }
    }
}

