/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal;

public interface JournalMetaStore {
    public void storeLastFlushedIndex(long var1);

    public long loadLastFlushedIndex();

    public void resetLastFlushedIndex();

    public boolean hasLastFlushedIndex();

    public static class InMemory
    implements JournalMetaStore {
        private volatile long index = -1L;

        @Override
        public void storeLastFlushedIndex(long index) {
            this.index = index;
        }

        @Override
        public long loadLastFlushedIndex() {
            return this.index;
        }

        @Override
        public void resetLastFlushedIndex() {
            this.index = -1L;
        }

        @Override
        public boolean hasLastFlushedIndex() {
            return this.index != -1L;
        }
    }
}

