/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.management;

import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.backup.management.BackupServiceImpl;
import io.camunda.zeebe.backup.management.InProgressBackupImpl;
import io.camunda.zeebe.backup.metrics.BackupManagerMetrics;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackupService
extends Actor
implements BackupManager {
    private static final Logger LOG = LoggerFactory.getLogger(BackupService.class);
    private final String actorName;
    private final int nodeId;
    private final int partitionId;
    private final int numberOfPartitions;
    private final BackupServiceImpl internalBackupManager;
    private final PersistedSnapshotStore snapshotStore;
    private final Path segmentsDirectory;
    private final Predicate<Path> isSegmentsFile;
    private final BackupManagerMetrics metrics;

    public BackupService(int nodeId, int partitionId, int numberOfPartitions, BackupStore backupStore, PersistedSnapshotStore snapshotStore, Path segmentsDirectory, Predicate<Path> isSegmentsFile) {
        this.nodeId = nodeId;
        this.partitionId = partitionId;
        this.numberOfPartitions = numberOfPartitions;
        this.snapshotStore = snapshotStore;
        this.segmentsDirectory = segmentsDirectory;
        this.isSegmentsFile = isSegmentsFile;
        this.metrics = new BackupManagerMetrics(partitionId);
        this.internalBackupManager = new BackupServiceImpl(backupStore);
        this.actorName = BackupService.buildActorName((String)"BackupService", (int)partitionId);
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorClosing() {
        this.internalBackupManager.close();
        this.metrics.cancelInProgressOperations();
    }

    @Override
    public void takeBackup(long checkpointId, long checkpointPosition) {
        this.actor.run(() -> {
            InProgressBackupImpl inProgressBackup = new InProgressBackupImpl(this.snapshotStore, this.getBackupId(checkpointId), checkpointPosition, this.numberOfPartitions, (ConcurrencyControl)this.actor, this.segmentsDirectory, this.isSegmentsFile);
            BackupManagerMetrics.OperationMetrics opMetrics = this.metrics.startTakingBackup();
            ActorFuture<Void> backupResult = this.internalBackupManager.takeBackup(inProgressBackup, (ConcurrencyControl)this.actor);
            backupResult.onComplete(opMetrics::complete);
            backupResult.onComplete((ignore, error) -> {
                if (error != null) {
                    LOG.warn("Failed to take backup {} at position {}", new Object[]{inProgressBackup.checkpointId(), inProgressBackup.checkpointPosition(), error});
                } else {
                    LOG.info("Backup {} at position {} completed", (Object)inProgressBackup.checkpointId(), (Object)inProgressBackup.checkpointPosition());
                }
            });
        });
    }

    @Override
    public ActorFuture<BackupStatus> getBackupStatus(long checkpointId) {
        BackupManagerMetrics.OperationMetrics operationMetrics = this.metrics.startQueryingStatus();
        CompletableActorFuture future = new CompletableActorFuture();
        this.internalBackupManager.getBackupStatus(this.partitionId, checkpointId, (ConcurrencyControl)this.actor).onComplete((backupStatus, throwable) -> {
            if (throwable != null) {
                LOG.warn("Failed to query status of backup {}", (Object)checkpointId, throwable);
                future.completeExceptionally(throwable);
            } else if (backupStatus.isEmpty()) {
                future.complete((Object)new BackupStatusImpl(this.getBackupId(checkpointId), Optional.empty(), BackupStatusCode.DOES_NOT_EXIST, Optional.empty(), Optional.empty(), Optional.empty()));
            } else {
                future.complete((Object)((BackupStatus)backupStatus.get()));
            }
        });
        future.onComplete(operationMetrics::complete);
        return future;
    }

    @Override
    public ActorFuture<Collection<BackupStatus>> listBackups() {
        BackupManagerMetrics.OperationMetrics operationMetrics = this.metrics.startListingBackups();
        ActorFuture<Collection<BackupStatus>> resultFuture = this.internalBackupManager.listBackups(this.partitionId, (ConcurrencyControl)this.actor);
        resultFuture.onComplete(operationMetrics::complete);
        resultFuture.onComplete((ignore, error) -> {
            if (error != null) {
                LOG.warn("Failed to list backups", error);
            }
        });
        return resultFuture;
    }

    @Override
    public ActorFuture<Void> deleteBackup(long checkpointId) {
        BackupManagerMetrics.OperationMetrics operationMetrics = this.metrics.startDeleting();
        ActorFuture<Void> backupDeleted = this.internalBackupManager.deleteBackup(this.partitionId, checkpointId, (ConcurrencyControl)this.actor);
        backupDeleted.onComplete(operationMetrics::complete);
        backupDeleted.onComplete((ignore, error) -> {
            if (error != null) {
                LOG.warn("Failed to delete backup {}", (Object)checkpointId, error);
            }
        });
        return backupDeleted;
    }

    @Override
    public void failInProgressBackup(long lastCheckpointId) {
        this.internalBackupManager.failInProgressBackups(this.partitionId, lastCheckpointId, (ConcurrencyControl)this.actor);
    }

    private BackupIdentifierImpl getBackupId(long checkpointId) {
        return new BackupIdentifierImpl(this.nodeId, this.partitionId, checkpointId);
    }
}

