/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ElementActivationBehavior;
import io.camunda.zeebe.engine.processing.common.EventSubscriptionException;
import io.camunda.zeebe.engine.processing.common.MultipleFlowScopeInstancesFoundException;
import io.camunda.zeebe.engine.processing.common.UnsupportedMultiInstanceBodyActivationException;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.Strings;

public final class ProcessInstanceModificationProcessor
implements TypedRecordProcessor<ProcessInstanceModificationRecord> {
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND = "Expected to modify process instance but no process instance found with key '%d'";
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_BELONGS_TO_SPECIFIC_TENANT = "Expected to modify process instance but process instance belongs to tenant '%s' while modification is not yet supported with multi-tenancy. Only process instances belonging to the default tenant '<default>' can be modified. See https://github.com/camunda/zeebe/issues/13288 for more details.";
    private static final String ERROR_MESSAGE_ACTIVATE_ELEMENT_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more activate instructions with an element that could not be found: '%s'";
    private static final String ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED = "Expected to modify instance of process '%s' but it contains one or more activate instructions for elements that are unsupported: '%s'. %s.";
    private static final String ERROR_MESSAGE_TERMINATE_ELEMENT_INSTANCE_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more terminate instructions with an element instance that could not be found: '%s'";
    private static final String ERROR_COMMAND_TOO_LARGE = "Unable to modify process instance with key '%d' as the size exceeds the maximum batch size. Please reduce the size by splitting the modification into multiple commands.";
    private static final String ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element id that could not be found: '%s'";
    private static final String ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FLOW_SCOPE = "Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element that doesn't belong to the activating element's flow scope. These variables should be set before or after the modification.";
    private static final String ERROR_MESSAGE_MORE_THAN_ONE_FLOW_SCOPE_INSTANCE = "Expected to modify instance of process '%s' but it contains one or more activate instructions for an element that has a flow scope with more than one active instance: '%s'. Can't decide in which instance of the flow scope the element should be activated. Please specify an ancestor element instance key for this activate instruction.";
    private static final String ERROR_MESSAGE_CHILD_PROCESS_INSTANCE_TERMINATED = "Expected to modify instance of process '%s' but the given instructions would terminate the instance. The instance was created by a call activity in the parent process. To terminate this instance please modify the parent process instead.";
    private static final String ERROR_MESSAGE_ANCESTOR_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not exist, or is not in an active state: '%s'";
    private static final String ERROR_MESSAGE_ATTEMPTED_TO_ACTIVATE_MULTI_INSTANCE = "Expected to modify instance of process '%s' but it contains one or more activate instructions that would result in the activation of multi-instance element '%s', which is currently unsupported.";
    private static final String ERROR_MESSAGE_ANCESTOR_WRONG_PROCESS_INSTANCE = "Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not belong to the modified process instance: '%s'";
    private static final String ERROR_MESSAGE_SELECTED_ANCESTOR_IS_NOT_ANCESTOR_OF_ELEMENT = "Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that is not an ancestor of the element to activate:%s";
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = Set.of(BpmnElementType.UNSPECIFIED, BpmnElementType.START_EVENT, BpmnElementType.SEQUENCE_FLOW, BpmnElementType.BOUNDARY_EVENT);
    private static final Set<BpmnElementType> SUPPORTED_ELEMENT_TYPES = Arrays.stream(BpmnElementType.values()).filter(elementType -> !UNSUPPORTED_ELEMENT_TYPES.contains(elementType)).collect(Collectors.toSet());
    private static final Either<Rejection, Object> VALID = Either.right(null);
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final CatchEventBehavior catchEventBehavior;
    private final ElementActivationBehavior elementActivationBehavior;
    private final VariableBehavior variableBehavior;

    public ProcessInstanceModificationProcessor(Writers writers, ElementInstanceState elementInstanceState, ProcessState processState, BpmnBehaviors bpmnBehaviors) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.elementActivationBehavior = bpmnBehaviors.elementActivationBehavior();
        this.variableBehavior = bpmnBehaviors.variableBehavior();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceModificationRecord> command) {
        long commandKey = command.getKey();
        ProcessInstanceModificationRecord value = (ProcessInstanceModificationRecord)command.getValue();
        long eventKey = commandKey > -1L ? commandKey : value.getProcessInstanceKey();
        ElementInstance processInstance = this.elementInstanceState.getInstance(value.getProcessInstanceKey());
        if (processInstance == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, eventKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        if (!TenantAuthorizationCheckerImpl.fromAuthorizationMap((Map)command.getAuthorizations()).isAuthorized(processInstance.getValue().getTenantId()).booleanValue()) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, eventKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        ProcessInstanceRecord processInstanceRecord = processInstance.getValue();
        DeployedProcess process = this.processState.getProcessByKeyAndTenant(processInstanceRecord.getProcessDefinitionKey(), processInstanceRecord.getTenantId());
        Either<Rejection, ?> validationResult = this.validateCommand(command, process);
        if (validationResult.isLeft()) {
            Rejection rejection = (Rejection)validationResult.getLeft();
            this.responseWriter.writeRejectionOnCommand(command, rejection.type(), rejection.reason());
            this.rejectionWriter.appendRejection(command, rejection.type(), rejection.reason());
            return;
        }
        ProcessInstanceModificationRecord extendedRecord = new ProcessInstanceModificationRecord();
        extendedRecord.setProcessInstanceKey(value.getProcessInstanceKey());
        Set requiredKeysForActivation = value.getActivateInstructions().stream().flatMap(instruction -> {
            AbstractFlowElement elementToActivate = process.getProcess().getElementById(instruction.getElementId());
            long ancestorScopeKey = instruction.getAncestorScopeKey();
            ElementActivationBehavior.ActivatedElementKeys activatedElementKeys = this.elementActivationBehavior.activateElement(processInstanceRecord, elementToActivate, ancestorScopeKey, (elementId, scopeKey) -> this.executeVariableInstruction(BufferUtil.bufferAsString((DirectBuffer)elementId), (Long)scopeKey, processInstance, process, (ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue)instruction));
            extendedRecord.addActivateInstruction(((ProcessInstanceModificationActivateInstruction)instruction).addAncestorScopeKeys(activatedElementKeys.getFlowScopeKeys()));
            return activatedElementKeys.getFlowScopeKeys().stream();
        }).collect(Collectors.toSet());
        value.getTerminateInstructions().forEach(instruction -> {
            extendedRecord.addTerminateInstruction(instruction);
            ElementInstance elementInstance = this.elementInstanceState.getInstance(instruction.getElementInstanceKey());
            if (elementInstance == null) {
                return;
            }
            long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
            this.terminateElement(elementInstance);
            this.terminateFlowScopes(flowScopeKey, requiredKeysForActivation);
        });
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (RecordValue)extendedRecord);
        this.responseWriter.writeEventOnCommand(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (UnpackedObject)extendedRecord, command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ProcessInstanceModificationRecord> typedCommand, Throwable error) {
        if (error instanceof EventSubscriptionException) {
            EventSubscriptionException exception = (EventSubscriptionException)error;
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof MultipleFlowScopeInstancesFoundException) {
            MultipleFlowScopeInstancesFoundException exception = (MultipleFlowScopeInstancesFoundException)error;
            String rejectionReason = ERROR_MESSAGE_MORE_THAN_ONE_FLOW_SCOPE_INSTANCE.formatted(exception.getBpmnProcessId(), exception.getFlowScopeId());
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, rejectionReason);
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, rejectionReason);
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof ExceededBatchRecordSizeException) {
            String message = ERROR_COMMAND_TOO_LARGE.formatted(((ProcessInstanceModificationRecord)typedCommand.getValue()).getProcessInstanceKey());
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, message);
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, message);
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof TerminatedChildProcessException) {
            TerminatedChildProcessException exception = (TerminatedChildProcessException)error;
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof UnsupportedMultiInstanceBodyActivationException) {
            UnsupportedMultiInstanceBodyActivationException exception = (UnsupportedMultiInstanceBodyActivationException)error;
            String message = ERROR_MESSAGE_ATTEMPTED_TO_ACTIVATE_MULTI_INSTANCE.formatted(exception.getBpmnProcessId(), exception.getMultiInstanceId());
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, message);
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, message);
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private Either<Rejection, ?> validateCommand(TypedRecord<ProcessInstanceModificationRecord> command, DeployedProcess process) {
        ProcessInstanceModificationRecord value = (ProcessInstanceModificationRecord)command.getValue();
        List activateInstructions = value.getActivateInstructions();
        List terminateInstructions = value.getTerminateInstructions();
        return this.validateElementExists(process, activateInstructions).flatMap(valid -> this.validateElementSupported(process, activateInstructions)).flatMap(valid -> this.validateElementInstanceExists(process, terminateInstructions)).flatMap(valid -> this.validateVariableScopeExists(process, activateInstructions)).flatMap(valid -> this.validateVariableScopeIsFlowScope(process, activateInstructions)).flatMap(valid -> this.validateAncestorKeys(process, value)).map(valid -> VALID);
    }

    private Either<Rejection, ?> validateElementExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set unknownElementIds = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).filter(targetElementId -> process.getProcess().getElementById((String)targetElementId) == null).collect(Collectors.toSet());
        if (unknownElementIds.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_ACTIVATE_ELEMENT_NOT_FOUND, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", unknownElementIds));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateElementSupported(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        return ProcessInstanceModificationProcessor.validateElementsDoNotBelongToEventBasedGateway(process, activateInstructions).flatMap(valid -> this.validateElementsHaveSupportedType(process, activateInstructions)).map(valid -> VALID);
    }

    private static Either<Rejection, ?> validateElementsDoNotBelongToEventBasedGateway(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        List<String> elementIdsConnectedToEventBasedGateway = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).distinct().filter(elementId -> {
            ExecutableCatchEventElement event;
            AbstractFlowElement element = process.getProcess().getElementById((String)elementId);
            return element instanceof ExecutableCatchEventElement && (event = (ExecutableCatchEventElement)element).isConnectedToEventBasedGateway();
        }).toList();
        if (elementIdsConnectedToEventBasedGateway.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", elementIdsConnectedToEventBasedGateway), "The activation of events belonging to an event-based gateway is not supported");
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateElementsHaveSupportedType(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        List<AbstractFlowElement> elementsWithUnsupportedElementType = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).distinct().map(elementId -> process.getProcess().getElementById((String)elementId)).filter(element -> UNSUPPORTED_ELEMENT_TYPES.contains(element.getElementType())).toList();
        if (elementsWithUnsupportedElementType.isEmpty()) {
            return VALID;
        }
        String usedUnsupportedElementIds = elementsWithUnsupportedElementType.stream().map(AbstractFlowElement::getId).map(BufferUtil::bufferAsString).collect(Collectors.joining("', '"));
        String usedUnsupportedElementTypes = elementsWithUnsupportedElementType.stream().map(AbstractFlowElement::getElementType).map(Objects::toString).distinct().collect(Collectors.joining("', '"));
        String reason = ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), usedUnsupportedElementIds, "The activation of elements with type '%s' is not supported. Supported element types are: %s".formatted(usedUnsupportedElementTypes, SUPPORTED_ELEMENT_TYPES));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateAncestorKeys(DeployedProcess process, ProcessInstanceModificationRecord record) {
        Map<Long, Optional<ElementInstance>> ancestorInstances = record.getActivateInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getAncestorScopeKey).filter(ancestorKey -> ancestorKey > 0L).distinct().collect(Collectors.toMap(ancestorKey -> ancestorKey, ancestorKey -> Optional.ofNullable(this.elementInstanceState.getInstance((long)ancestorKey))));
        return this.validateAncestorExistsAndIsActive(process, record, ancestorInstances).flatMap(valid -> this.validateAncestorBelongsToProcessInstance(process, record, ancestorInstances)).flatMap(valid -> this.validateAncestorIsFlowScopeOfElement(process, record, ancestorInstances)).map(valid -> VALID);
    }

    private Either<Rejection, ?> validateAncestorExistsAndIsActive(DeployedProcess process, ProcessInstanceModificationRecord record, Map<Long, Optional<ElementInstance>> ancestorInstances) {
        Set invalidAncestorKeys = record.getActivateInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getAncestorScopeKey).distinct().filter(ancestorKey -> ancestorKey > 0L).filter(ancestorKey -> {
            Optional elementInstanceOptional = (Optional)ancestorInstances.get(ancestorKey);
            return elementInstanceOptional.isEmpty() || !((ElementInstance)((Object)((Object)elementInstanceOptional.get()))).isActive();
        }).map(String::valueOf).collect(Collectors.toSet());
        if (invalidAncestorKeys.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_ANCESTOR_NOT_FOUND, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", invalidAncestorKeys));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateAncestorBelongsToProcessInstance(DeployedProcess process, ProcessInstanceModificationRecord record, Map<Long, Optional<ElementInstance>> ancestorInstances) {
        Set rejectedAncestorKeys = ancestorInstances.values().stream().flatMap(Optional::stream).filter(ancestorInstance -> ancestorInstance.getValue().getProcessInstanceKey() != record.getProcessInstanceKey()).map(ancestorInstance -> String.valueOf(ancestorInstance.getKey())).collect(Collectors.toSet());
        if (rejectedAncestorKeys.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_ANCESTOR_WRONG_PROCESS_INSTANCE, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", rejectedAncestorKeys));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateAncestorIsFlowScopeOfElement(DeployedProcess process, ProcessInstanceModificationRecord record, Map<Long, Optional<ElementInstance>> ancestorInstances) {
        record InstructionDetails(long ancestorScopeKey, String ancestorId, String elementId) {
        }
        String invalidInstructionMessages = record.getActivateInstructions().stream().filter(instruction -> instruction.getAncestorScopeKey() > 0L).map(instruction -> {
            String ancestorId = ((Optional)ancestorInstances.get(instruction.getAncestorScopeKey())).map(ElementInstance::getValue).map(ProcessInstanceRecord::getElementId).orElse(null);
            return new InstructionDetails(instruction.getAncestorScopeKey(), ancestorId, instruction.getElementId());
        }).filter(details -> details.ancestorId != null).filter(details -> !this.isAncestorOfElement(process, details.ancestorId, details.elementId)).map(details -> "%n- instance '%s' of element '%s' is not an ancestor of element '%s'".formatted(details.ancestorScopeKey, details.ancestorId, details.elementId)).collect(Collectors.joining());
        if (invalidInstructionMessages.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_SELECTED_ANCESTOR_IS_NOT_ANCESTOR_OF_ELEMENT, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), invalidInstructionMessages);
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private boolean isAncestorOfElement(DeployedProcess process, String ancestorId, String elementId) {
        AbstractFlowElement potentialDescendant = process.getProcess().getElementById(elementId);
        if (potentialDescendant.getFlowScope() == null) {
            return false;
        }
        String potentialDescendantsFlowScopeId = BufferUtil.bufferAsString((DirectBuffer)potentialDescendant.getFlowScope().getId());
        if (Objects.equals(ancestorId, potentialDescendantsFlowScopeId)) {
            return true;
        }
        return this.isAncestorOfElement(process, ancestorId, potentialDescendantsFlowScopeId);
    }

    private Either<Rejection, ?> validateElementInstanceExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> terminateInstructions) {
        List<Long> unknownElementInstanceKeys = terminateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue::getElementInstanceKey).distinct().filter(instanceKey -> this.elementInstanceState.getInstance((long)instanceKey) == null).toList();
        if (unknownElementInstanceKeys.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_TERMINATE_ELEMENT_INSTANCE_NOT_FOUND, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), unknownElementInstanceKeys.stream().map(Objects::toString).collect(Collectors.joining("', '")));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateVariableScopeExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set unknownScopeElementIds = activateInstructions.stream().flatMap(instruction -> instruction.getVariableInstructions().stream()).map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue::getElementId).filter(Predicate.not(String::isEmpty)).filter(scopeElementId -> process.getProcess().getElementById((String)scopeElementId) == null).collect(Collectors.toSet());
        if (unknownScopeElementIds.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FOUND.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", unknownScopeElementIds));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateVariableScopeIsFlowScope(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set nonFlowScopeIds = activateInstructions.stream().flatMap(instruction -> {
            String elementId = instruction.getElementId();
            AbstractFlowElement elementToActivate = process.getProcess().getElementById(elementId);
            return instruction.getVariableInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue::getElementId).filter(Predicate.not(String::isEmpty)).filter(Predicate.not(elementId::equals)).filter(scopeElementId -> !this.isFlowScopeOfElement(elementToActivate, (String)scopeElementId));
        }).collect(Collectors.toSet());
        if (nonFlowScopeIds.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FLOW_SCOPE.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private boolean isFlowScopeOfElement(ExecutableFlowElement element, String targetElementId) {
        for (ExecutableFlowElement flowScope = element.getFlowScope(); flowScope != null; flowScope = flowScope.getFlowScope()) {
            String flowScopeId = BufferUtil.bufferAsString((DirectBuffer)flowScope.getId());
            if (!flowScopeId.equals(targetElementId)) continue;
            return true;
        }
        return false;
    }

    public void executeVariableInstruction(String elementId, Long scopeKey, ElementInstance processInstance, DeployedProcess process, ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue activate) {
        activate.getVariableInstructions().stream().filter(instruction -> instruction.getElementId().equals(elementId) || Strings.isEmpty((String)instruction.getElementId()) && elementId.equals(processInstance.getValue().getBpmnProcessId())).map(instruction -> {
            if (instruction instanceof ProcessInstanceModificationVariableInstruction) {
                ProcessInstanceModificationVariableInstruction vi = (ProcessInstanceModificationVariableInstruction)instruction;
                return vi.getVariablesBuffer();
            }
            throw new UnsupportedOperationException("Expected variable instruction of type %s, but was %s".formatted(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue.class.getName(), instruction.getClass().getName()));
        }).forEach(variableDocument -> this.variableBehavior.mergeLocalDocument(scopeKey, process.getKey(), processInstance.getKey(), process.getBpmnProcessId(), process.getTenantId(), (DirectBuffer)variableDocument));
    }

    private void terminateElement(ElementInstance elementInstance) {
        ElementInstance calledActivityElementInstance;
        long elementInstanceKey = elementInstance.getKey();
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        BpmnElementType elementType = elementInstance.getValue().getBpmnElementType();
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_TERMINATING, (RecordValue)elementInstanceRecord);
        this.jobBehavior.cancelJob(elementInstance);
        this.incidentBehavior.resolveIncidents(elementInstanceKey);
        this.catchEventBehavior.unsubscribeFromEvents(elementInstanceKey);
        if (elementType == BpmnElementType.EVENT_SUB_PROCESS || elementType == BpmnElementType.SUB_PROCESS || elementType == BpmnElementType.PROCESS || elementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            this.elementInstanceState.getChildren(elementInstanceKey).stream().filter(ElementInstance::canTerminate).forEach(this::terminateElement);
        } else if (elementType == BpmnElementType.CALL_ACTIVITY && (calledActivityElementInstance = this.elementInstanceState.getInstance(elementInstance.getCalledChildInstanceKey())) != null && calledActivityElementInstance.canTerminate()) {
            this.terminateElement(calledActivityElementInstance);
        }
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_TERMINATED, (RecordValue)elementInstanceRecord);
    }

    private void terminateFlowScopes(long elementInstanceKey, Set<Long> requiredKeysForActivation) {
        ElementInstance currentElementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        while (this.canTerminateElementInstance(currentElementInstance, requiredKeysForActivation)) {
            ProcessInstanceRecord currentElementInstanceRecord = currentElementInstance.getValue();
            if (currentElementInstanceRecord.getBpmnElementType() == BpmnElementType.PROCESS && currentElementInstanceRecord.hasParentProcess()) {
                throw new TerminatedChildProcessException(ERROR_MESSAGE_CHILD_PROCESS_INSTANCE_TERMINATED.formatted(currentElementInstanceRecord.getBpmnProcessId()));
            }
            long flowScopeKey = currentElementInstance.getValue().getFlowScopeKey();
            this.terminateElement(currentElementInstance);
            currentElementInstance = this.elementInstanceState.getInstance(flowScopeKey);
        }
    }

    private boolean canTerminateElementInstance(ElementInstance elementInstance, Set<Long> requiredKeysForActivation) {
        return elementInstance != null && elementInstance.getNumberOfActiveElementInstances() == 0 && elementInstance.getActiveSequenceFlows() == 0L && !requiredKeysForActivation.contains(elementInstance.getKey());
    }

    private record Rejection(RejectionType type, String reason) {
    }

    private static class TerminatedChildProcessException
    extends RuntimeException {
        TerminatedChildProcessException(String message) {
            super(message);
        }
    }
}

