/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public final class JoinRequest
extends AbstractRaftRequest {
    private final RaftMember joining;

    private JoinRequest(RaftMember joining) {
        this.joining = Objects.requireNonNull(joining);
    }

    public RaftMember joiningMember() {
        return this.joining;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.joining);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinRequest that = (JoinRequest)o;
        return Objects.equals(this.joining, that.joining);
    }

    public String toString() {
        return "JoinRequest{joining=" + this.joining + "}";
    }

    public static final class Builder
    extends AbstractRaftRequest.Builder<Builder, JoinRequest> {
        private RaftMember joining;

        private Builder() {
        }

        public Builder withJoiningMember(RaftMember joining) {
            this.joining = joining;
            return this;
        }

        public JoinRequest build() {
            this.validate();
            return new JoinRequest(this.joining);
        }

        @Override
        protected void validate() {
            Objects.requireNonNull(this.joining, "joining member cannot be null");
        }
    }
}

