/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.ClientStream;
import io.camunda.zeebe.transport.stream.api.ClientStreamConsumer;
import io.camunda.zeebe.transport.stream.impl.AggregatedClientStream;
import io.camunda.zeebe.transport.stream.impl.ClientStreamIdImpl;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import org.agrona.DirectBuffer;

final class ClientStreamImpl<M extends BufferWriter>
extends Record
implements ClientStream<M> {
    private final ClientStreamIdImpl streamId;
    private final AggregatedClientStream<M> serverStream;
    private final DirectBuffer streamType;
    private final M metadata;
    private final ClientStreamConsumer clientStreamConsumer;

    ClientStreamImpl(ClientStreamIdImpl streamId, AggregatedClientStream<M> serverStream, DirectBuffer streamType, M metadata, ClientStreamConsumer clientStreamConsumer) {
        this.streamId = streamId;
        this.serverStream = serverStream;
        this.streamType = streamType;
        this.metadata = metadata;
        this.clientStreamConsumer = clientStreamConsumer;
    }

    ActorFuture<Void> push(DirectBuffer payload) {
        try {
            return this.clientStreamConsumer.push(payload);
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public Set<MemberId> liveConnections() {
        return this.serverStream().liveConnections();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientStreamImpl.class, "streamId;serverStream;streamType;metadata;clientStreamConsumer", "streamId", "serverStream", "streamType", "metadata", "clientStreamConsumer"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientStreamImpl.class, "streamId;serverStream;streamType;metadata;clientStreamConsumer", "streamId", "serverStream", "streamType", "metadata", "clientStreamConsumer"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientStreamImpl.class, "streamId;serverStream;streamType;metadata;clientStreamConsumer", "streamId", "serverStream", "streamType", "metadata", "clientStreamConsumer"}, this, o);
    }

    @Override
    public ClientStreamIdImpl streamId() {
        return this.streamId;
    }

    public AggregatedClientStream<M> serverStream() {
        return this.serverStream;
    }

    @Override
    public DirectBuffer streamType() {
        return this.streamType;
    }

    @Override
    public M metadata() {
        return this.metadata;
    }

    public ClientStreamConsumer clientStreamConsumer() {
        return this.clientStreamConsumer;
    }
}

