/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.Member;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.RemoteStreamInfo;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import io.camunda.zeebe.transport.stream.api.RemoteStreamer;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamTransport;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamerImpl;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;

public class RemoteStreamServiceImpl<M extends BufferReader, P extends BufferWriter>
implements RemoteStreamService<M, P> {
    private final RemoteStreamerImpl<M, P> streamer;
    private final RemoteStreamTransport<M> apiServer;
    private final RemoteStreamRegistry<M> registry;

    public RemoteStreamServiceImpl(RemoteStreamerImpl<M, P> streamer, RemoteStreamTransport<M> apiServer, RemoteStreamRegistry<M> registry) {
        this.streamer = streamer;
        this.apiServer = apiServer;
        this.registry = registry;
    }

    @Override
    public ActorFuture<RemoteStreamer<M, P>> start(ActorSchedulingService actorSchedulingService, ConcurrencyControl executor) {
        CompletableActorFuture future = new CompletableActorFuture();
        ActorFuture streamerStarted = actorSchedulingService.submitActor(this.streamer);
        ActorFuture serverStarted = actorSchedulingService.submitActor(this.apiServer);
        ActorFuture combined = (ActorFuture)Stream.of(streamerStarted, serverStarted).collect(new ActorFutureCollector(executor));
        executor.runOnCompletion(combined, (ok, error) -> {
            if (error != null) {
                future.completeExceptionally(error);
            } else {
                future.complete(this.streamer);
            }
        });
        return future;
    }

    @Override
    public ActorFuture<Void> closeAsync(ConcurrencyControl executor) {
        CompletableActorFuture closed = new CompletableActorFuture();
        ActorFuture streamerClosed = this.streamer.closeAsync();
        ActorFuture serverClosed = this.apiServer.closeAsync();
        ActorFuture combined = (ActorFuture)Stream.of(streamerClosed, serverClosed).collect(new ActorFutureCollector(executor));
        executor.runOnCompletion(combined, (ok, error) -> {
            if (error != null) {
                closed.completeExceptionally(error);
            } else {
                closed.complete(null);
            }
        });
        return closed;
    }

    @Override
    public Collection<RemoteStreamInfo<M>> streams() {
        return new HashSet<RemoteStreamInfo<M>>(this.registry.list());
    }

    public boolean isRelevant(ClusterMembershipEvent event) {
        return event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED;
    }

    public void event(ClusterMembershipEvent event) {
        this.apiServer.removeAll(((Member)event.subject()).id());
        if (event.type() == ClusterMembershipEvent.Type.MEMBER_ADDED) {
            this.apiServer.recreateStreams(((Member)event.subject()).id());
        }
    }
}

