/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.topology.ClusterTopologyManager;
import io.camunda.zeebe.topology.PersistedClusterTopology;
import io.camunda.zeebe.topology.TopologyInitializer;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterTopologyManagerImpl
implements ClusterTopologyManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterTopologyManagerImpl.class);
    private final ConcurrencyControl executor;
    private final PersistedClusterTopology persistedClusterTopology;
    private Consumer<ClusterTopology> topologyGossiper;
    private final ActorFuture<Void> startFuture;
    private TopologyChangeAppliers changeAppliers;
    private final MemberId localMemberId;
    private boolean onGoingTopologyChangeOperation = false;

    ClusterTopologyManagerImpl(ConcurrencyControl executor, MemberId localMemberId, PersistedClusterTopology persistedClusterTopology) {
        this.executor = executor;
        this.persistedClusterTopology = persistedClusterTopology;
        this.startFuture = executor.createFuture();
        this.localMemberId = localMemberId;
    }

    @Override
    public ActorFuture<ClusterTopology> getClusterTopology() {
        return this.executor.call(this.persistedClusterTopology::getTopology);
    }

    @Override
    public ActorFuture<ClusterTopology> updateClusterTopology(UnaryOperator<ClusterTopology> topologyUpdated) {
        ActorFuture future = this.executor.createFuture();
        this.executor.run(() -> {
            try {
                ClusterTopology updatedTopology = (ClusterTopology)topologyUpdated.apply(this.persistedClusterTopology.getTopology());
                this.updateLocalTopology(updatedTopology).ifRightOrLeft(updated -> {
                    future.complete(updated);
                    this.applyTopologyChangeOperation(updatedTopology);
                }, arg_0 -> ((ActorFuture)future).completeExceptionally(arg_0));
            }
            catch (Exception e) {
                LOG.error("Failed to update cluster topology", (Throwable)e);
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    ActorFuture<Void> start(TopologyInitializer topologyInitializer) {
        this.executor.run(() -> {
            if (this.startFuture.isDone()) {
                return;
            }
            this.initialize(topologyInitializer);
        });
        return this.startFuture;
    }

    public void setTopologyGossiper(Consumer<ClusterTopology> topologyGossiper) {
        this.topologyGossiper = topologyGossiper;
    }

    private void initialize(TopologyInitializer topologyInitializer) {
        topologyInitializer.initialize().onComplete((topology, error) -> {
            if (error != null) {
                LOG.error("Failed to initialize topology", error);
                this.startFuture.completeExceptionally(error);
            } else if (topology.isUninitialized()) {
                String errorMessage = "Expected to initialize topology, but got uninitialized topology";
                LOG.error("Expected to initialize topology, but got uninitialized topology");
                this.startFuture.completeExceptionally((Throwable)new IllegalStateException("Expected to initialize topology, but got uninitialized topology"));
            } else {
                try {
                    this.persistedClusterTopology.update(topology.merge(this.persistedClusterTopology.getTopology()));
                    this.topologyGossiper.accept(this.persistedClusterTopology.getTopology());
                    this.setStarted();
                }
                catch (IOException e) {
                    this.startFuture.completeExceptionally("Failed to start update cluster topology", (Throwable)e);
                }
            }
        });
    }

    private void setStarted() {
        if (!this.startFuture.isDone()) {
            this.startFuture.complete(null);
        }
    }

    ActorFuture<ClusterTopology> onGossipReceived(ClusterTopology receivedTopology) {
        ActorFuture result = this.executor.createFuture();
        this.executor.run(() -> {
            try {
                ClusterTopology mergedTopology;
                if (receivedTopology != null && !(mergedTopology = this.persistedClusterTopology.getTopology().merge(receivedTopology)).equals(this.persistedClusterTopology.getTopology())) {
                    LOG.debug("Received new topology {}. Updating local topology to {}", (Object)receivedTopology, (Object)mergedTopology);
                    this.persistedClusterTopology.update(mergedTopology);
                    this.applyTopologyChangeOperation(mergedTopology);
                }
                result.complete((Object)this.persistedClusterTopology.getTopology());
            }
            catch (IOException error) {
                result.completeExceptionally((Throwable)error);
            }
        });
        return result;
    }

    private boolean shouldApplyTopologyChangeOperation(ClusterTopology mergedTopology) {
        return !this.onGoingTopologyChangeOperation && mergedTopology.pendingChangesFor(this.localMemberId).isPresent() && this.changeAppliers != null;
    }

    private void applyTopologyChangeOperation(ClusterTopology mergedTopology) {
        if (!this.shouldApplyTopologyChangeOperation(mergedTopology)) {
            return;
        }
        this.onGoingTopologyChangeOperation = true;
        TopologyChangeOperation operation = mergedTopology.pendingChangesFor(this.localMemberId).orElseThrow();
        LOG.info("Applying topology change operation {}", (Object)operation);
        TopologyChangeAppliers.OperationApplier operationApplier = this.changeAppliers.getApplier(operation);
        Either initialized = operationApplier.init(mergedTopology).map(transformer -> mergedTopology.updateMember(this.localMemberId, (UnaryOperator<MemberState>)transformer)).map(this::updateLocalTopology);
        if (initialized.isLeft()) {
            LOG.error("Failed to initialize topology change operation {}", (Object)operation, initialized.getLeft());
            return;
        }
        operationApplier.apply().onComplete((transformer, error) -> this.onOperationApplied(operation, (UnaryOperator<MemberState>)transformer, (Throwable)error));
    }

    private void onOperationApplied(TopologyChangeOperation operation, UnaryOperator<MemberState> transformer, Throwable error) {
        this.onGoingTopologyChangeOperation = false;
        if (error == null) {
            this.updateLocalTopology(this.persistedClusterTopology.getTopology().advanceTopologyChange(this.localMemberId, transformer));
            LOG.info("Operation {} applied. Updated local topology to {}", (Object)operation, (Object)this.persistedClusterTopology.getTopology());
        } else {
            LOG.error("Failed to apply topology change operation {}", (Object)operation, (Object)error);
        }
    }

    private Either<Exception, ClusterTopology> updateLocalTopology(ClusterTopology topology) {
        if (topology.equals(this.persistedClusterTopology.getTopology())) {
            return Either.right((Object)topology);
        }
        try {
            this.persistedClusterTopology.update(topology);
            this.topologyGossiper.accept(topology);
            return Either.right((Object)topology);
        }
        catch (Exception e) {
            return Either.left((Object)e);
        }
    }

    void registerTopologyChangeAppliers(TopologyChangeAppliers topologyChangeAppliers) {
        this.executor.run(() -> {
            this.changeAppliers = topologyChangeAppliers;
            this.applyTopologyChangeOperation(this.persistedClusterTopology.getTopology());
        });
    }

    public void removeTopologyChangeAppliers() {
        this.executor.run(() -> {
            this.changeAppliers = null;
        });
    }
}

