/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.camunda.zeebe.topology.serializer.ClusterTopologySerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

final class PersistedClusterTopology {
    private final Path topologyFile;
    private final ClusterTopologySerializer serializer;
    private ClusterTopology clusterTopology = ClusterTopology.uninitialized();

    PersistedClusterTopology(Path topologyFile, ClusterTopologySerializer serializer) {
        this.topologyFile = topologyFile;
        this.serializer = serializer;
    }

    ClusterTopology getTopology() {
        return this.clusterTopology;
    }

    void update(ClusterTopology clusterTopology) throws IOException {
        if (this.clusterTopology.equals(clusterTopology)) {
            return;
        }
        byte[] serializedTopology = this.serializer.encode(clusterTopology);
        Files.write(this.topologyFile, serializedTopology, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        this.clusterTopology = clusterTopology;
    }

    public boolean isUninitialized() {
        return this.clusterTopology.isUninitialized();
    }
}

