/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.PersistedClusterTopology;
import io.camunda.zeebe.topology.StaticConfiguration;
import io.camunda.zeebe.topology.TopologyUpdateNotifier;
import io.camunda.zeebe.topology.serializer.ClusterTopologySerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TopologyInitializer {
    public ActorFuture<ClusterTopology> initialize();

    default public TopologyInitializer orThen(TopologyInitializer after) {
        TopologyInitializer actual = this;
        return () -> {
            CompletableActorFuture chainedInitialize = new CompletableActorFuture();
            actual.initialize().onComplete((arg_0, arg_1) -> TopologyInitializer.lambda$orThen$0(after, (ActorFuture)chainedInitialize, arg_0, arg_1));
            return chainedInitialize;
        };
    }

    private static /* synthetic */ void lambda$orThen$0(TopologyInitializer after, ActorFuture chainedInitialize, ClusterTopology topology, Throwable error) {
        if (error != null || topology.isUninitialized()) {
            after.initialize().onComplete((BiConsumer)chainedInitialize);
        } else {
            chainedInitialize.complete((Object)topology);
        }
    }

    public static class StaticInitializer
    implements TopologyInitializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(StaticInitializer.class);
        private final StaticConfiguration staticConfiguration;

        public StaticInitializer(StaticConfiguration staticConfiguration) {
            this.staticConfiguration = staticConfiguration;
        }

        @Override
        public ActorFuture<ClusterTopology> initialize() {
            try {
                ClusterTopology topology = this.staticConfiguration.generateTopology();
                LOGGER.debug("Generated cluster topology from provided configuration. {}", (Object)topology);
                return CompletableActorFuture.completed((Object)topology);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
        }
    }

    public static class SyncInitializer
    implements TopologyInitializer,
    TopologyUpdateNotifier.TopologyUpdateListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(SyncInitializer.class);
        private static final Duration SYNC_QUERY_RETRY_DELAY = Duration.ofSeconds(5L);
        private final TopologyUpdateNotifier topologyUpdateNotifier;
        private final ActorFuture<ClusterTopology> initialized;
        private final List<MemberId> knownMembersToSync;
        private final ConcurrencyControl executor;
        private final Function<MemberId, ActorFuture<ClusterTopology>> syncRequester;

        public SyncInitializer(TopologyUpdateNotifier topologyUpdateNotifier, List<MemberId> knownMembersToSync, ConcurrencyControl executor, Function<MemberId, ActorFuture<ClusterTopology>> syncRequester) {
            this.topologyUpdateNotifier = topologyUpdateNotifier;
            this.knownMembersToSync = knownMembersToSync;
            this.executor = executor;
            this.syncRequester = syncRequester;
            this.initialized = new CompletableActorFuture();
        }

        @Override
        public ActorFuture<ClusterTopology> initialize() {
            if (this.knownMembersToSync.isEmpty()) {
                this.initialized.complete((Object)ClusterTopology.uninitialized());
            } else {
                LOGGER.debug("Querying members {} before initializing ClusterTopology", this.knownMembersToSync);
                this.topologyUpdateNotifier.addUpdateListener(this);
                this.knownMembersToSync.forEach(this::tryInitializeFrom);
            }
            return this.initialized;
        }

        private void tryInitializeFrom(MemberId memberId) {
            this.requestSync(memberId).onComplete((topology, error) -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (error != null) {
                    LOGGER.trace("Failed to get a response for cluster topology sync query to {}. Will retry.", (Object)memberId, error);
                } else if (topology == null) {
                    LOGGER.trace("Received null cluster topology from {}. Will retry.", (Object)memberId);
                } else {
                    if (topology.isUninitialized()) {
                        LOGGER.trace("Cluster topology is uninitialized in {}", (Object)memberId);
                        this.initialized.complete(topology);
                        return;
                    }
                    LOGGER.debug("Received cluster topology {} from {}", topology, (Object)memberId);
                    this.onTopologyUpdated((ClusterTopology)topology);
                    return;
                }
                if (!this.initialized.isDone()) {
                    this.executor.schedule(SYNC_QUERY_RETRY_DELAY, () -> this.tryInitializeFrom(memberId));
                }
            });
        }

        private ActorFuture<ClusterTopology> requestSync(MemberId memberId) {
            return this.syncRequester.apply(memberId);
        }

        @Override
        public void onTopologyUpdated(ClusterTopology clusterTopology) {
            this.executor.run(() -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (!clusterTopology.isUninitialized()) {
                    this.initialized.complete((Object)clusterTopology);
                    this.topologyUpdateNotifier.removeUpdateListener(this);
                }
            });
        }
    }

    public static class GossipInitializer
    implements TopologyInitializer,
    TopologyUpdateNotifier.TopologyUpdateListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(GossipInitializer.class);
        private final TopologyUpdateNotifier topologyUpdateNotifier;
        private final PersistedClusterTopology persistedClusterTopology;
        private final Consumer<ClusterTopology> topologyGossiper;
        private final ActorFuture<ClusterTopology> initialized;
        private final ConcurrencyControl executor;

        public GossipInitializer(TopologyUpdateNotifier topologyUpdateNotifier, PersistedClusterTopology persistedClusterTopology, Consumer<ClusterTopology> topologyGossiper, ConcurrencyControl executor) {
            this.topologyUpdateNotifier = topologyUpdateNotifier;
            this.persistedClusterTopology = persistedClusterTopology;
            this.topologyGossiper = topologyGossiper;
            this.executor = executor;
            this.initialized = new CompletableActorFuture();
        }

        @Override
        public ActorFuture<ClusterTopology> initialize() {
            this.topologyUpdateNotifier.addUpdateListener(this);
            if (this.persistedClusterTopology.isUninitialized()) {
                this.topologyGossiper.accept(this.persistedClusterTopology.getTopology());
            }
            return this.initialized;
        }

        @Override
        public void onTopologyUpdated(ClusterTopology clusterTopology) {
            this.executor.run(() -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (!clusterTopology.isUninitialized()) {
                    LOGGER.debug("Received cluster topology {} via gossip.", (Object)clusterTopology);
                    this.initialized.complete((Object)clusterTopology);
                    this.topologyUpdateNotifier.removeUpdateListener(this);
                }
            });
        }
    }

    public static class FileInitializer
    implements TopologyInitializer {
        private final Path topologyFile;
        private final ClusterTopologySerializer serializer;

        public FileInitializer(Path topologyFile, ClusterTopologySerializer serializer) {
            this.topologyFile = topologyFile;
            this.serializer = serializer;
        }

        @Override
        public ActorFuture<ClusterTopology> initialize() {
            try {
                byte[] serializedTopology;
                if (Files.exists(this.topologyFile, new LinkOption[0]) && (serializedTopology = Files.readAllBytes(this.topologyFile)).length > 0) {
                    ClusterTopology clusterTopology = this.serializer.decodeClusterTopology(serializedTopology);
                    return CompletableActorFuture.completed((Object)clusterTopology);
                }
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
            return CompletableActorFuture.completed((Object)ClusterTopology.uninitialized());
        }
    }
}

