/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.MemberJoinApplier;
import io.camunda.zeebe.topology.changes.MemberLeaveApplier;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.PartitionJoinApplier;
import io.camunda.zeebe.topology.changes.PartitionLeaveApplier;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.changes.TopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class TopologyChangeAppliersImpl
implements TopologyChangeAppliers {
    private final PartitionChangeExecutor partitionChangeExecutor;
    private final TopologyMembershipChangeExecutor topologyMembershipChangeExecutor;

    public TopologyChangeAppliersImpl(PartitionChangeExecutor partitionChangeExecutor, TopologyMembershipChangeExecutor topologyMembershipChangeExecutor) {
        this.partitionChangeExecutor = partitionChangeExecutor;
        this.topologyMembershipChangeExecutor = topologyMembershipChangeExecutor;
    }

    @Override
    public TopologyChangeAppliers.OperationApplier getApplier(TopologyChangeOperation operation) {
        if (operation instanceof TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation) {
            TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)operation;
            return new PartitionJoinApplier(joinOperation.partitionId(), joinOperation.priority(), joinOperation.memberId(), this.partitionChangeExecutor);
        }
        if (operation instanceof TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation) {
            TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)operation;
            return new PartitionLeaveApplier(leaveOperation.partitionId(), leaveOperation.memberId(), this.partitionChangeExecutor);
        }
        if (operation instanceof TopologyChangeOperation.MemberJoinOperation) {
            TopologyChangeOperation.MemberJoinOperation memberJoinOperation = (TopologyChangeOperation.MemberJoinOperation)operation;
            return new MemberJoinApplier(memberJoinOperation.memberId(), this.topologyMembershipChangeExecutor);
        }
        if (operation instanceof TopologyChangeOperation.MemberLeaveOperation) {
            TopologyChangeOperation.MemberLeaveOperation memberLeaveOperation = (TopologyChangeOperation.MemberLeaveOperation)operation;
            return new MemberLeaveApplier(memberLeaveOperation.memberId(), this.topologyMembershipChangeExecutor);
        }
        return new FailingApplier(operation);
    }

    static class FailingApplier
    implements TopologyChangeAppliers.OperationApplier {
        private final TopologyChangeOperation operation;

        public FailingApplier(TopologyChangeOperation operation) {
            this.operation = operation;
        }

        @Override
        public Either<Exception, UnaryOperator<MemberState>> init(ClusterTopology currentClusterTopology) {
            return Either.left((Object)new UnknownOperationException(this.operation));
        }

        @Override
        public ActorFuture<UnaryOperator<MemberState>> apply() {
            return CompletableActorFuture.completedExceptionally((Throwable)new UnknownOperationException(this.operation));
        }

        private static class UnknownOperationException
        extends RuntimeException {
            public UnknownOperationException(TopologyChangeOperation operation) {
                super("Unknown topology change operation " + operation);
            }
        }
    }
}

