/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.topology.ClusterTopologyManager;
import io.camunda.zeebe.topology.changes.NoopPartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.NoopTopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliersImpl;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyChangeCoordinatorImpl
implements TopologyChangeCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyChangeCoordinatorImpl.class);
    private final ClusterTopologyManager clusterTopologyManager;
    private final ConcurrencyControl executor;

    public TopologyChangeCoordinatorImpl(ClusterTopologyManager clusterTopologyManager, ConcurrencyControl executor) {
        this.clusterTopologyManager = clusterTopologyManager;
        this.executor = executor;
    }

    @Override
    public ActorFuture<ClusterTopology> applyOperations(List<TopologyChangeOperation> operations) {
        ActorFuture future = this.executor.createFuture();
        this.clusterTopologyManager.getClusterTopology().onComplete((currentClusterTopology, errorOnGettingTopology) -> {
            if (errorOnGettingTopology != null) {
                future.completeExceptionally(errorOnGettingTopology);
                return;
            }
            ActorFuture<ClusterTopology> validation = this.validateTopologyChangeRequest((ClusterTopology)currentClusterTopology, operations);
            validation.onComplete((simulatedFinalTopology, validationError) -> {
                if (validationError != null) {
                    future.completeExceptionally(validationError);
                    return;
                }
                this.applyTopologyChange(operations, (ClusterTopology)currentClusterTopology, (ClusterTopology)simulatedFinalTopology, (ActorFuture<ClusterTopology>)future);
            });
        });
        return future;
    }

    @Override
    public ActorFuture<Boolean> hasCompletedChanges(long version) {
        ActorFuture future = this.executor.createFuture();
        this.clusterTopologyManager.getClusterTopology().onComplete((currentClusterTopology, error) -> {
            if (error != null) {
                future.completeExceptionally(error);
                return;
            }
            if (currentClusterTopology.version() == version) {
                future.complete((Object)(!currentClusterTopology.hasPendingChanges() ? 1 : 0));
            } else if (currentClusterTopology.version() == version + 1L) {
                future.complete((Object)true);
            } else if (currentClusterTopology.version() > version + 1L) {
                future.completeExceptionally((Throwable)new UnknownStatus(String.format("The topology has changed since the version %d. The current version is %d. The topology change would have been already completed.", version, currentClusterTopology.version())));
            } else if (currentClusterTopology.version() < version) {
                future.completeExceptionally((Throwable)new IllegalArgumentException(String.format("Expected version >= %d, but the current version is %d.", version, currentClusterTopology.version())));
            }
        });
        return future;
    }

    private ActorFuture<ClusterTopology> validateTopologyChangeRequest(ClusterTopology currentClusterTopology, List<TopologyChangeOperation> operations) {
        ActorFuture validationFuture = this.executor.createFuture();
        if (currentClusterTopology.isUninitialized()) {
            validationFuture.completeExceptionally((Throwable)new OperationNotAllowed("Cannot apply topology change. The topology is not initialized."));
        } else if (currentClusterTopology.hasPendingChanges()) {
            validationFuture.completeExceptionally((Throwable)new OperationNotAllowed(String.format("Cannot apply topology change. Another topology change [%s] is in progress.", currentClusterTopology)));
        } else {
            TopologyChangeAppliersImpl topologyChangeSimulator = new TopologyChangeAppliersImpl(new NoopPartitionChangeExecutor(), new NoopTopologyMembershipChangeExecutor());
            ClusterTopology topologyWithPendingOperations = currentClusterTopology.startTopologyChange(operations);
            this.simulateTopologyChange(topologyWithPendingOperations, topologyChangeSimulator, (ActorFuture<ClusterTopology>)validationFuture);
        }
        return validationFuture;
    }

    private void applyTopologyChange(List<TopologyChangeOperation> operations, ClusterTopology currentClusterTopology, ClusterTopology simulatedFinalTopology, ActorFuture<ClusterTopology> future) {
        this.clusterTopologyManager.updateClusterTopology(clusterTopology -> {
            if (!clusterTopology.equals(currentClusterTopology)) {
                throw new ConcurrentModificationException("Topology changed while applying the change. Please retry.");
            }
            return clusterTopology.startTopologyChange(operations);
        }).onComplete((topologyWithPendingOperations, errorOnUpdatingTopology) -> {
            if (errorOnUpdatingTopology != null) {
                future.completeExceptionally(errorOnUpdatingTopology);
                return;
            }
            LOG.debug("Applying the topology change has started. The resulting topology will be {}", (Object)simulatedFinalTopology);
            future.complete(topologyWithPendingOperations);
        });
    }

    private void simulateTopologyChange(ClusterTopology updatedTopology, TopologyChangeAppliersImpl topologyChangeSimulator, ActorFuture<ClusterTopology> simulationCompleted) {
        if (updatedTopology.changes().pendingOperations().isEmpty()) {
            simulationCompleted.complete((Object)updatedTopology);
            return;
        }
        TopologyChangeOperation operation = updatedTopology.changes().pendingOperations().get(0);
        TopologyChangeAppliers.OperationApplier applier = topologyChangeSimulator.getApplier(operation);
        Either<Exception, UnaryOperator<MemberState>> result = applier.init(updatedTopology);
        if (result.isLeft()) {
            simulationCompleted.completeExceptionally((Throwable)new InvalidTopologyChangeException((Throwable)result.getLeft()));
            return;
        }
        ClusterTopology initializedChanges = updatedTopology.updateMember(operation.memberId(), (UnaryOperator)result.get());
        applier.apply().onComplete((stateUpdater, error) -> {
            if (error != null) {
                simulationCompleted.completeExceptionally((Throwable)new InvalidTopologyChangeException((Throwable)error));
                return;
            }
            ClusterTopology newTopology = initializedChanges.advanceTopologyChange(operation.memberId(), (UnaryOperator<MemberState>)stateUpdater);
            this.simulateTopologyChange(newTopology, topologyChangeSimulator, simulationCompleted);
        });
    }

    static class OperationNotAllowed
    extends RuntimeException {
        public OperationNotAllowed(String message) {
            super(message);
        }
    }

    static class InvalidTopologyChangeException
    extends RuntimeException {
        public InvalidTopologyChangeException(Throwable cause) {
            super(cause);
        }
    }

    static class UnknownStatus
    extends RuntimeException {
        public UnknownStatus(String message) {
            super(message);
        }
    }
}

